/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.csv.CSVImporterDocumentFactory;

public class DefaultCSVImporterDocumentFactory
implements CSVImporterDocumentFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public void createDocument(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) throws ClientException {
        DocumentModel doc = session.createDocumentModel(parentPath, name, type);
        session.createDocument(doc);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        session.saveDocument(doc);
    }

    @Override
    public void updateDocument(CoreSession session, DocumentRef docRef, Map<String, Serializable> values) throws ClientException {
        DocumentModel doc = session.getDocument(docRef);
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        session.saveDocument(doc);
    }

    @Override
    public boolean exists(CoreSession session, String parentPath, String name, String type, Map<String, Serializable> values) throws ClientException {
        String targetPath = new Path(parentPath).append(name).toString();
        PathRef docRef = new PathRef(targetPath);
        return session.exists((DocumentRef)docRef);
    }
}

