/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.csv.core.CSVImportLog;

public class CSVImportResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final long totalLineCount;
    protected final long successLineCount;
    protected final long skippedLineCount;
    protected final long errorLineCount;

    public static final CSVImportResult fromImportLogs(List<CSVImportLog> importLogs) {
        long totalLineCount = importLogs.size();
        long successLineCount = 0L;
        long skippedLineCount = 0L;
        long errorLineCount = 0L;
        for (CSVImportLog importLog : importLogs) {
            if (importLog.isSuccess()) {
                ++successLineCount;
                continue;
            }
            if (importLog.isSkipped()) {
                ++skippedLineCount;
                continue;
            }
            if (!importLog.isError()) continue;
            ++errorLineCount;
        }
        return new CSVImportResult(totalLineCount, successLineCount, skippedLineCount, errorLineCount);
    }

    public CSVImportResult(long totalLineCount, long successLineCount, long skippedLineCount, long errorLineCount) {
        this.totalLineCount = totalLineCount;
        this.successLineCount = successLineCount;
        this.skippedLineCount = skippedLineCount;
        this.errorLineCount = errorLineCount;
    }

    public long getTotalLineCount() {
        return this.totalLineCount;
    }

    public long getSuccessLineCount() {
        return this.successLineCount;
    }

    public long getSkippedLineCount() {
        return this.skippedLineCount;
    }

    public long getErrorLineCount() {
        return this.errorLineCount;
    }
}

