/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.jsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.csv.core.CSVImportLog;
import org.nuxeo.ecm.csv.core.CSVImportResult;
import org.nuxeo.ecm.csv.core.CSVImportStatus;
import org.nuxeo.ecm.csv.core.CSVImporter;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.FileUploadEvent;
import org.richfaces.model.UploadedFile;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="csvImportActions")
@Install(precedence=10)
public class CSVImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected File csvFile;
    protected String csvFileName;
    protected boolean notifyUserByEmail = false;
    protected String csvImportId;
    protected Boolean useImportMode = false;

    public boolean getNotifyUserByEmail() {
        return this.notifyUserByEmail;
    }

    public void setNotifyUserByEmail(boolean notifyUserByEmail) {
        this.notifyUserByEmail = notifyUserByEmail;
    }

    public Boolean getUseImportMode() {
        return this.useImportMode;
    }

    public void setUseImportMode(Boolean importMode) {
        this.useImportMode = importMode;
    }

    protected CSVImporterOptions.ImportMode getImportMode() {
        return this.useImportMode != false ? CSVImporterOptions.ImportMode.IMPORT : CSVImporterOptions.ImportMode.CREATE;
    }

    public void uploadListener(FileUploadEvent event) throws Exception {
        UploadedFile item = event.getUploadedFile();
        this.csvFile = Framework.createTempFile((String)"FileManageActionsFile", null);
        InputStream in = event.getUploadedFile().getInputStream();
        FileUtils.copyToFile((InputStream)in, (File)this.csvFile);
        this.csvFileName = FilenameUtils.getName((String)item.getName());
    }

    public void importCSVFile() throws IOException {
        if (this.csvFile != null) {
            CSVImporterOptions options = new CSVImporterOptions.Builder().sendEmail(this.notifyUserByEmail).importMode(this.getImportMode()).build();
            CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
            this.csvImportId = csvImporter.launchImport(this.documentManager, this.navigationContext.getCurrentDocument().getPathAsString(), Blobs.createBlob((File)this.csvFile, null, null, (String)this.csvFileName), options);
        }
    }

    public String getImportingCSVFilename() {
        return this.csvFileName;
    }

    public CSVImportStatus getImportStatus() {
        if (this.csvImportId == null) {
            return null;
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
        return csvImporter.getImportStatus(this.csvImportId);
    }

    public List<CSVImportLog> getLastLogs(int maxLogs) {
        if (this.csvImportId == null) {
            return Collections.emptyList();
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
        return csvImporter.getLastImportLogs(this.csvImportId, maxLogs);
    }

    public List<CSVImportLog> getSkippedAndErrorLogs() {
        if (this.csvImportId == null) {
            return Collections.emptyList();
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
        return csvImporter.getImportLogs(this.csvImportId, new CSVImportLog.Status[]{CSVImportLog.Status.SKIPPED, CSVImportLog.Status.ERROR});
    }

    public CSVImportResult getImportResult() {
        if (this.csvImportId == null) {
            return null;
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
        return csvImporter.getImportResult(this.csvImportId);
    }

    @Observer(value={"navigateToDocument"})
    public void resetState() {
        this.csvFile = null;
        this.csvFileName = null;
        this.csvImportId = null;
        this.notifyUserByEmail = false;
    }
}

