/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.csv.core.CSVImportLog;
import org.nuxeo.ecm.csv.core.CSVImportResult;
import org.nuxeo.ecm.csv.core.CSVImportStatus;
import org.nuxeo.ecm.csv.core.CSVImporter;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.ecm.csv.core.CSVImporterWork;

public class CSVImporterImpl
implements CSVImporter {
    private static final Log log = LogFactory.getLog(CSVImporterImpl.class);

    @Override
    @Deprecated
    public String launchImport(CoreSession session, String parentPath, File csvFile, String csvFileName, CSVImporterOptions options) {
        try {
            return new CSVImporterWork(session.getRepositoryName(), parentPath, session.getPrincipal().getName(), Blobs.createBlob((File)csvFile), options).launch();
        }
        catch (IOException e) {
            log.error((Object)"Cannot launch csv import work.", (Throwable)e);
            throw new NuxeoException("Cannot launch csv import work.", (Throwable)e);
        }
    }

    @Override
    public String launchImport(CoreSession session, String parentPath, Blob blob, CSVImporterOptions options) {
        return new CSVImporterWork(session.getRepositoryName(), parentPath, session.getPrincipal().getName(), blob, options).launch();
    }

    @Override
    public CSVImportStatus getImportStatus(String id) {
        return CSVImporterWork.getStatus(id);
    }

    @Override
    public List<CSVImportLog> getImportLogs(String id) {
        return this.getLastImportLogs(id, -1);
    }

    @Override
    public List<CSVImportLog> getImportLogs(String id, CSVImportLog.Status ... status) {
        return this.getLastImportLogs(id, -1, status);
    }

    @Override
    public List<CSVImportLog> getLastImportLogs(String id, int max) {
        List<CSVImportLog> importLogs = CSVImporterWork.getLastImportLogs(id);
        max = max == -1 || max > importLogs.size() ? importLogs.size() : max;
        return importLogs.subList(importLogs.size() - max, importLogs.size());
    }

    @Override
    public List<CSVImportLog> getLastImportLogs(String id, int max, CSVImportLog.Status ... status) {
        List<CSVImportLog> importLogs = this.getLastImportLogs(id, max);
        return status.length == 0 ? importLogs : this.filterImportLogs(importLogs, status);
    }

    protected List<CSVImportLog> filterImportLogs(List<CSVImportLog> importLogs, CSVImportLog.Status ... status) {
        List<CSVImportLog.Status> statusList = Arrays.asList(status);
        return importLogs.stream().filter(log -> statusList.contains((Object)log.getStatus())).collect(Collectors.toList());
    }

    @Override
    public CSVImportResult getImportResult(String id) {
        return CSVImportResult.fromImportLogs(this.getLastImportLogs(id, -1));
    }
}

