/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.operations.notification.MailTemplateHelper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.csv.core.CSVImportId;
import org.nuxeo.ecm.csv.core.CSVImportLog;
import org.nuxeo.ecm.csv.core.CSVImportResult;
import org.nuxeo.ecm.csv.core.CSVImportStatus;
import org.nuxeo.ecm.csv.core.CSVImporter;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CSVImporterWork
extends TransientStoreWork {
    public static final String NUXEO_CSV_MAIL_TO = "nuxeo.csv.mail.to";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_FIELD = "label.csv.importer.notExistingField";
    public static final String LABEL_CSV_IMPORTER_CANNOT_CONVERT_FIELD_VALUE = "label.csv.importer.cannotConvertFieldValue";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_FILE = "label.csv.importer.notExistingFile";
    public static final String NUXEO_CSV_BLOBS_FOLDER = "nuxeo.csv.blobs.folder";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_ALREADY_EXISTS = "label.csv.importer.documentAlreadyExists";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_UPDATE = "label.csv.importer.unableToUpdate";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_UPDATED = "label.csv.importer.documentUpdated";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_CREATE = "label.csv.importer.unableToCreate";
    public static final String LABEL_CSV_IMPORTER_PARENT_DOES_NOT_EXIST = "label.csv.importer.parentDoesNotExist";
    public static final String LABEL_CSV_IMPORTER_DOCUMENT_CREATED = "label.csv.importer.documentCreated";
    public static final String LABEL_CSV_IMPORTER_NOT_ALLOWED_SUB_TYPE = "label.csv.importer.notAllowedSubType";
    public static final String LABEL_CSV_IMPORTER_UNABLE_TO_SAVE = "label.csv.importer.unableToSave";
    public static final String LABEL_CSV_IMPORTER_ERROR_IMPORTING_LINE = "label.csv.importer.errorImportingLine";
    public static final String LABEL_CSV_IMPORTER_NOT_EXISTING_TYPE = "label.csv.importer.notExistingType";
    public static final String LABEL_CSV_IMPORTER_MISSING_TYPE_VALUE = "label.csv.importer.missingTypeValue";
    public static final String LABEL_CSV_IMPORTER_MISSING_NAME_VALUE = "label.csv.importer.missingNameValue";
    public static final String LABEL_CSV_IMPORTER_MISSING_NAME_COLUMN = "label.csv.importer.missingNameColumn";
    public static final String LABEL_CSV_IMPORTER_EMPTY_FILE = "label.csv.importer.emptyFile";
    public static final String LABEL_CSV_IMPORTER_ERROR_DURING_IMPORT = "label.csv.importer.errorDuringImport";
    public static final String LABEL_CSV_IMPORTER_EMPTY_LINE = "label.csv.importer.emptyLine";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CSVImporterWork.class);
    private static final String TEMPLATE_IMPORT_RESULT = "templates/csvImportResult.ftl";
    public static final String CATEGORY_CSV_IMPORTER = "csvImporter";
    public static final String CONTENT_FILED_TYPE_NAME = "content";
    private static final long COMPUTE_TOTAL_THRESHOLD_KB = 1000L;
    protected static final List<String> AUTHORIZED_HEADERS = Arrays.asList("ecm:currentLifeCycleState", "ecm:uuid");
    protected String parentPath;
    protected String username;
    protected CSVImporterOptions options;
    protected transient DateFormat dateformat;
    protected boolean hasTypeColumn;
    protected Date startDate;
    protected ArrayList<CSVImportLog> importLogs = new ArrayList();
    protected boolean computeTotal = false;
    protected long total = -1L;
    protected long docsCreatedCount;
    static final Serializable EMPTY_LOGS = new ArrayList();

    public CSVImporterWork(String id) {
        super(id);
    }

    public CSVImporterWork(String repositoryName, String parentPath, String username, Blob csvBlob, CSVImporterOptions options) {
        super(CSVImportId.create(repositoryName, parentPath, csvBlob));
        CSVImporterWork.getStore().putBlobs(this.id, Collections.singletonList(csvBlob));
        this.setDocument(repositoryName, null);
        this.setOriginatingUsername(username);
        this.parentPath = parentPath;
        this.username = username;
        if (csvBlob.getLength() >= 0L && csvBlob.getLength() / 1024L < 1000L) {
            this.computeTotal = true;
        }
        this.options = options;
        this.startDate = new Date();
    }

    public String getCategory() {
        return CATEGORY_CSV_IMPORTER;
    }

    public String getTitle() {
        return String.format("CSV import in '%s'", this.parentPath);
    }

    public List<CSVImportLog> getImportLogs() {
        return new ArrayList<CSVImportLog>(this.importLogs);
    }

    public void work() {
        TransientStore store = CSVImporterWork.getStore();
        this.setStatus("Importing");
        this.openUserSession();
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[0]).withEscape(this.options.getEscapeCharacter()).withCommentMarker(this.options.getCommentMarker());
        try (BufferedReader in = this.newReader(this.getBlob());
             CSVParser parser = csvFormat.parse((Reader)in);){
            this.doImport(parser);
        }
        catch (IOException e) {
            this.logError(0L, "Error while doing the import: %s", LABEL_CSV_IMPORTER_ERROR_DURING_IMPORT, e.getMessage());
            log.debug((Object)e, (Throwable)e);
        }
        store.putParameter(this.id, "logs", this.importLogs);
        if (this.options.sendEmail()) {
            this.setStatus("Sending email");
            this.sendMail();
        }
        this.setStatus(null);
    }

    public void cleanUp(boolean ok, Exception e) {
        try {
            super.cleanUp(ok, e);
        }
        finally {
            CSVImporterWork.getStore().putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.COMPLETED, this.total, this.total));
        }
    }

    String launch() {
        WorkManager works = (WorkManager)Framework.getService(WorkManager.class);
        TransientStore store = CSVImporterWork.getStore();
        store.putParameter(this.id, "logs", EMPTY_LOGS);
        store.putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.SCHEDULED));
        works.schedule((Work)this);
        return this.id;
    }

    static CSVImportStatus getStatus(String id) {
        TransientStore store = CSVImporterWork.getStore();
        if (!store.exists(id)) {
            return null;
        }
        return (CSVImportStatus)store.getParameter(id, "status");
    }

    static List<CSVImportLog> getLastImportLogs(String id) {
        TransientStore store = CSVImporterWork.getStore();
        if (!store.exists(id)) {
            return Collections.emptyList();
        }
        return (ArrayList)store.getParameter(id, "logs");
    }

    protected BufferedReader newReader(Blob blob) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream(blob.getStream())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(CSVParser parser) {
        log.info((Object)String.format("Importing CSV file: %s", this.getBlob().getFilename()));
        Map header = parser.getHeaderMap();
        if (header == null) {
            this.logError(0L, "No header line, empty file?", LABEL_CSV_IMPORTER_EMPTY_FILE, new String[0]);
            return;
        }
        if (!header.containsKey("name")) {
            this.logError(0L, "Missing 'name' column", LABEL_CSV_IMPORTER_MISSING_NAME_COLUMN, new String[0]);
            return;
        }
        this.hasTypeColumn = header.containsKey("type");
        try {
            int batchSize = this.options.getBatchSize();
            Object it = parser;
            if (this.computeTotal) {
                try {
                    List l = parser.getRecords();
                    this.total = l.size();
                    it = l;
                }
                catch (IOException e) {
                    log.warn((Object)"Could not compute total number of document to be imported");
                }
            }
            for (CSVRecord record : it) {
                if (record.size() == 0) {
                    this.importLogs.add(new CSVImportLog(this.getLineNumber(record), CSVImportLog.Status.SKIPPED, "Empty record", LABEL_CSV_IMPORTER_EMPTY_LINE, new String[0]));
                    continue;
                }
                try {
                    if (!this.importRecord(record, header)) continue;
                    ++this.docsCreatedCount;
                    CSVImporterWork.getStore().putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.RUNNING, this.docsCreatedCount, this.total));
                    if (this.docsCreatedCount % (long)batchSize != 0L) continue;
                    this.commitOrRollbackTransaction();
                    this.startTransaction();
                }
                catch (NuxeoException e) {
                    Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                    this.logError(this.getLineNumber(parser), "Error while importing line: %s", LABEL_CSV_IMPORTER_ERROR_IMPORTING_LINE, unwrappedException.getMessage());
                    log.debug((Object)unwrappedException, unwrappedException);
                }
            }
            try {
                this.session.save();
            }
            catch (NuxeoException e) {
                Throwable ue = CSVImporterWork.unwrapException(e);
                this.logError(this.getLineNumber(parser), "Unable to save: %s", LABEL_CSV_IMPORTER_UNABLE_TO_SAVE, ue.getMessage());
                log.debug((Object)ue, ue);
            }
        }
        finally {
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
        log.info((Object)String.format("Done importing CSV file: %s", this.getBlob().getFilename()));
    }

    protected boolean importRecord(CSVRecord record, Map<String, Integer> header) {
        String name = record.get("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            log.debug((Object)("record.isSet=" + record.isSet("name")));
            this.logError(this.getLineNumber(record), "Missing 'name' value", LABEL_CSV_IMPORTER_MISSING_NAME_VALUE, new String[0]);
            return false;
        }
        Path targetPath = new Path(this.parentPath).append(name);
        name = targetPath.lastSegment();
        String newParentPath = targetPath.removeLastSegments(1).toString();
        boolean exists = this.options.getCSVImporterDocumentFactory().exists(this.session, newParentPath, name, null);
        PathRef docRef = null;
        String type = null;
        if (exists) {
            docRef = new PathRef(targetPath.toString());
            type = this.session.getDocument((DocumentRef)docRef).getType();
        } else {
            if (this.hasTypeColumn) {
                type = record.get("type");
            }
            if (StringUtils.isBlank(type)) {
                log.debug((Object)("record.isSet=" + record.isSet("type")));
                this.logError(this.getLineNumber(record), "Missing 'type' value", LABEL_CSV_IMPORTER_MISSING_TYPE_VALUE, new String[0]);
                return false;
            }
        }
        DocumentType docType = ((SchemaManager)Framework.getService(SchemaManager.class)).getDocumentType(type);
        if (docType == null) {
            this.logError(this.getLineNumber(record), "The type '%s' does not exist", LABEL_CSV_IMPORTER_NOT_EXISTING_TYPE, type);
            return false;
        }
        Map<String, Serializable> properties = this.computePropertiesMap(record, (CompositeType)docType, header);
        if (properties == null) {
            return false;
        }
        long lineNumber = this.getLineNumber(record);
        if (exists) {
            return this.updateDocument(lineNumber, (DocumentRef)docRef, properties);
        }
        return this.createDocument(lineNumber, newParentPath, name, type, properties);
    }

    protected long getLineNumber(CSVRecord record) {
        return record.getRecordNumber() + 1L;
    }

    protected long getLineNumber(CSVParser parser) {
        return parser.getRecordNumber() + 1L;
    }

    protected Map<String, Serializable> computePropertiesMap(CSVRecord record, CompositeType compositeType, Map<String, Integer> header) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (String headerValue : header.keySet()) {
            String lineValue = record.get(headerValue);
            lineValue = lineValue.trim();
            String fieldName = headerValue;
            if ("name".equals(headerValue) || "type".equals(headerValue)) continue;
            if (AUTHORIZED_HEADERS.contains(headerValue) && !StringUtils.isBlank((CharSequence)lineValue)) {
                values.put(headerValue, (Serializable)((Object)lineValue));
                continue;
            }
            if (!compositeType.hasField(fieldName)) {
                fieldName = fieldName.split(":")[1];
            }
            if (!compositeType.hasField(fieldName) || StringUtils.isBlank((CharSequence)lineValue)) continue;
            Serializable convertedValue = this.convertValue(compositeType, fieldName, headerValue, lineValue, this.getLineNumber(record));
            if (convertedValue == null) {
                return null;
            }
            values.put(headerValue, convertedValue);
        }
        return values;
    }

    protected Serializable convertValue(CompositeType compositeType, String fieldName, String headerValue, String stringValue, long lineNumber) {
        if (compositeType.hasField(fieldName)) {
            Field field = compositeType.getField(fieldName);
            if (field != null) {
                try {
                    Object fieldValue = null;
                    Type fieldType = field.getType();
                    if (fieldType.isComplexType()) {
                        if (fieldType.getName().equals(CONTENT_FILED_TYPE_NAME)) {
                            fieldValue = (String[])this.createBlobFromFilePath(stringValue);
                            if (fieldValue == null) {
                                this.logError(lineNumber, "The file '%s' does not exist", LABEL_CSV_IMPORTER_NOT_EXISTING_FILE, stringValue);
                                return null;
                            }
                        } else {
                            fieldValue = (Serializable)ComplexTypeJSONDecoder.decode((ComplexType)((ComplexType)fieldType), (String)stringValue);
                            this.replaceBlobs((Map)fieldValue);
                        }
                    } else if (fieldType.isListType()) {
                        Type listFieldType = ((ListType)fieldType).getFieldType();
                        if (listFieldType.isSimpleType()) {
                            fieldValue = stringValue.split(this.options.getListSeparatorRegex());
                        } else {
                            fieldValue = (Serializable)((Object)ComplexTypeJSONDecoder.decodeList((ListType)((ListType)fieldType), (String)stringValue));
                            this.replaceBlobs((List)fieldValue);
                        }
                    } else {
                        Type type = field.getType();
                        if (type instanceof SimpleTypeImpl) {
                            type = type.getSuperType();
                        }
                        if (type.isSimpleType()) {
                            if (type instanceof StringType) {
                                fieldValue = stringValue;
                            } else if (type instanceof IntegerType) {
                                fieldValue = Integer.valueOf(stringValue);
                            } else if (type instanceof LongType) {
                                fieldValue = Long.valueOf(stringValue);
                            } else if (type instanceof DoubleType) {
                                fieldValue = Double.valueOf(stringValue);
                            } else if (type instanceof BooleanType) {
                                fieldValue = Boolean.valueOf(stringValue);
                            } else if (type instanceof DateType) {
                                fieldValue = this.getDateFormat().parse(stringValue);
                            }
                        }
                    }
                    return fieldValue;
                }
                catch (IOException | NumberFormatException | ParseException e) {
                    this.logError(lineNumber, "Unable to convert field '%s' with value '%s'", LABEL_CSV_IMPORTER_CANNOT_CONVERT_FIELD_VALUE, headerValue, stringValue);
                    log.debug((Object)e, (Throwable)e);
                }
            }
        } else {
            this.logError(lineNumber, "Field '%s' does not exist on type '%s'", LABEL_CSV_IMPORTER_NOT_EXISTING_FIELD, headerValue, compositeType.getName());
        }
        return null;
    }

    protected Blob createBlobFromFilePath(String fileRelativePath) throws IOException {
        String blobsFolderPath = Framework.getProperty((String)NUXEO_CSV_BLOBS_FOLDER);
        String path = FilenameUtils.normalize((String)(blobsFolderPath + "/" + fileRelativePath));
        File file = new File(path);
        if (file.exists()) {
            return Blobs.createBlob((File)file, null, null, (String)FilenameUtils.getName((String)fileRelativePath));
        }
        return null;
    }

    protected Blob createBlobFromStringBlob(Blob stringBlob) throws IOException {
        String fileRelativePath = stringBlob.getString();
        Blob blob = this.createBlobFromFilePath(fileRelativePath);
        if (blob == null) {
            throw new IOException(String.format("File %s does not exist", fileRelativePath));
        }
        blob.setMimeType(stringBlob.getMimeType());
        blob.setEncoding(stringBlob.getEncoding());
        String filename = stringBlob.getFilename();
        if (filename != null) {
            blob.setFilename(filename);
        }
        return blob;
    }

    protected void replaceBlobs(Map<String, Object> map) throws IOException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                entry.setValue(this.createBlobFromStringBlob(blob));
                continue;
            }
            if (value instanceof List) {
                this.replaceBlobs((List)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.replaceBlobs((Map)value);
        }
    }

    protected void replaceBlobs(List<Object> list) throws IOException {
        ListIterator<Object> it = list.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                it.set(this.createBlobFromStringBlob(blob));
                continue;
            }
            if (value instanceof List) {
                this.replaceBlobs((List)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.replaceBlobs((Map)value);
        }
    }

    protected DateFormat getDateFormat() {
        if (this.dateformat == null) {
            this.dateformat = new SimpleDateFormat(this.options.getDateFormat());
        }
        return this.dateformat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createDocument(long lineNumber, String newParentPath, String name, String type, Map<String, Serializable> properties) {
        try {
            PathRef parentRef = new PathRef(newParentPath);
            if (!this.session.exists((DocumentRef)parentRef)) {
                this.logError(lineNumber, "Parent document '%s' does not exist", LABEL_CSV_IMPORTER_PARENT_DOES_NOT_EXIST, newParentPath);
                return false;
            }
            DocumentModel parent = this.session.getDocument((DocumentRef)parentRef);
            TypeManager typeManager = (TypeManager)Framework.getService(TypeManager.class);
            if (this.options.checkAllowedSubTypes() && !typeManager.isAllowedSubType(type, parent.getType())) {
                this.logError(lineNumber, "'%s' type is not allowed in '%s'", LABEL_CSV_IMPORTER_NOT_ALLOWED_SUB_TYPE, type, parent.getType());
                return false;
            }
            this.options.getCSVImporterDocumentFactory().createDocument(this.session, newParentPath, name, type, properties);
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document created", LABEL_CSV_IMPORTER_DOCUMENT_CREATED, new String[0]));
            return true;
        }
        catch (RuntimeException e) {
            Throwable unwrappedException = CSVImporterWork.unwrapException(e);
            this.logError(lineNumber, "Unable to create document: %s", LABEL_CSV_IMPORTER_UNABLE_TO_CREATE, unwrappedException.getMessage());
            log.debug((Object)unwrappedException, unwrappedException);
        }
        return false;
    }

    protected boolean updateDocument(long lineNumber, DocumentRef docRef, Map<String, Serializable> properties) {
        if (this.options.updateExisting()) {
            try {
                this.options.getCSVImporterDocumentFactory().updateDocument(this.session, docRef, properties);
                this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document updated", LABEL_CSV_IMPORTER_DOCUMENT_UPDATED, new String[0]));
                return true;
            }
            catch (RuntimeException e) {
                Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                this.logError(lineNumber, "Unable to update document: %s", LABEL_CSV_IMPORTER_UNABLE_TO_UPDATE, unwrappedException.getMessage());
                log.debug((Object)unwrappedException, unwrappedException);
            }
        } else {
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SKIPPED, "Document already exists", LABEL_CSV_IMPORTER_DOCUMENT_ALREADY_EXISTS, new String[0]));
        }
        return false;
    }

    protected void logError(long lineNumber, String message, String localizedMessage, String ... params) {
        this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.ERROR, String.format(message, params), localizedMessage, params));
        String lineMessage = String.format("Line %d", lineNumber);
        String errorMessage = String.format(message, params);
        log.error((Object)String.format("%s: %s", lineMessage, errorMessage));
        CSVImporterWork.getStore().putParameter(this.id, "status", (Serializable)new CSVImportStatus(CSVImportStatus.State.ERROR, this.docsCreatedCount, this.docsCreatedCount));
    }

    protected void sendMail() {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        NuxeoPrincipal principal = userManager.getPrincipal(this.username);
        String email = principal.getEmail();
        if (email == null) {
            log.info((Object)String.format("Not sending import result email to '%s', no email configured", this.username));
            return;
        }
        try (OperationContext ctx = new OperationContext(this.session);){
            ctx.setInput((Object)this.session.getRootDocument());
            CSVImporter csvImporter = (CSVImporter)Framework.getService(CSVImporter.class);
            List<CSVImportLog> importerLogs = csvImporter.getImportLogs(this.getId());
            CSVImportResult importResult = CSVImportResult.fromImportLogs(importerLogs);
            List<CSVImportLog> skippedAndErrorImportLogs = csvImporter.getImportLogs(this.getId(), CSVImportLog.Status.SKIPPED, CSVImportLog.Status.ERROR);
            ctx.put("importResult", (Object)importResult);
            ctx.put("skippedAndErrorImportLogs", skippedAndErrorImportLogs);
            ctx.put("csvFilename", (Object)this.getBlob().getFilename());
            ctx.put("startDate", (Object)DateFormat.getInstance().format(this.startDate));
            ctx.put("username", (Object)this.username);
            DocumentModel importFolder = this.session.getDocument((DocumentRef)new PathRef(this.parentPath));
            String importFolderUrl = this.getDocumentUrl(importFolder);
            ctx.put("importFolderTitle", (Object)importFolder.getTitle());
            ctx.put("importFolderUrl", (Object)importFolderUrl);
            ctx.put("userUrl", (Object)this.getUserUrl());
            StringList to = this.buildRecipientsList(email);
            Expression from = Scripting.newExpression((String)"Env[\"mail.from\"]");
            String subject = "CSV Import result of " + this.getBlob().getFilename();
            String message = CSVImporterWork.loadTemplate(TEMPLATE_IMPORT_RESULT);
            OperationChain chain = new OperationChain("SendMail");
            chain.add("Document.Mail").set("from", (Object)from).set("to", (Object)to).set("HTML", (Object)true).set("subject", (Object)subject).set("message", (Object)message);
            ((AutomationService)Framework.getService(AutomationService.class)).run(ctx, chain);
        }
        catch (Exception e) {
            ExceptionUtils.checkInterrupt((Exception)e);
            log.error((Object)String.format("Unable to notify user '%s' for import result of '%s': %s", this.username, this.getBlob().getFilename(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            throw ExceptionUtils.runtimeException((Exception)e);
        }
    }

    private Blob getBlob() {
        return (Blob)CSVImporterWork.getStore().getBlobs(this.id).get(0);
    }

    protected String getDocumentUrl(DocumentModel doc) {
        return MailTemplateHelper.getDocumentUrl((DocumentModel)doc, null);
    }

    protected String getUserUrl() {
        DocumentViewCodecManager codecService = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
        DocumentViewCodec codec = codecService.getCodec("notificationDocId");
        boolean isNotificationCodec = codec != null;
        boolean isJSFUI = isNotificationCodec && "nxdoc".equals(codec.getPrefix());
        StringBuilder userUrl = new StringBuilder();
        if (isNotificationCodec) {
            userUrl.append(NotificationServiceHelper.getNotificationService().getServerUrlPrefix());
            if (!isJSFUI) {
                userUrl.append("ui/");
                userUrl.append("#!/");
            }
            userUrl.append("user/").append(this.username);
        }
        return userUrl.toString();
    }

    protected StringList buildRecipientsList(String userEmail) {
        String csvMailTo = Framework.getProperty((String)NUXEO_CSV_MAIL_TO);
        if (StringUtils.isBlank((CharSequence)csvMailTo)) {
            return new StringList(new String[]{userEmail});
        }
        return new StringList(new String[]{userEmail, csvMailTo});
    }

    private static String loadTemplate(String key) {
        InputStream io = CSVImporterWork.class.getClassLoader().getResourceAsStream(key);
        if (io != null) {
            try {
                String string = IOUtils.toString((InputStream)io, (Charset)StandardCharsets.UTF_8);
                return string;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            finally {
                try {
                    io.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t != null) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return CSVImporterWork.unwrapException(cause);
    }
}

