/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.nuxeo.ecm.csv.core.CSVImporterDocumentFactory;
import org.nuxeo.ecm.csv.core.DefaultCSVImporterDocumentFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class CSVImporterOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LEGACY_DATE_FORMAT_PROP = "nuxeo.csv.import.legacyDateFormat";
    public static final String LEGACY_DATE_FORMAT = "MM/dd/yyyy";
    public static final CSVImporterOptions DEFAULT_OPTIONS = new Builder().build();
    protected ImportMode importMode;
    protected final CSVImporterDocumentFactory CSVImporterDocumentFactory;
    protected final DateFormat dateFormat;
    protected final String listSeparatorRegex;
    protected final Character commentMarker;
    protected final Character escapeCharacter;
    protected final boolean updateExisting;
    protected final boolean checkAllowedSubTypes;
    protected final boolean sendEmail;
    protected final int batchSize;

    protected CSVImporterOptions(CSVImporterDocumentFactory CSVImporterDocumentFactory2, String dateFormat, String listSeparatorRegex, boolean updateExisting, boolean checkAllowedSubTypes, boolean sendEmail, int batchSize, ImportMode importMode) {
        this(CSVImporterDocumentFactory2, dateFormat, listSeparatorRegex, Character.valueOf('\\'), updateExisting, checkAllowedSubTypes, sendEmail, batchSize, importMode);
    }

    protected CSVImporterOptions(CSVImporterDocumentFactory CSVImporterDocumentFactory2, String dateFormat, String listSeparatorRegex, Character escapeCharacter, boolean updateExisting, boolean checkAllowedSubTypes, boolean sendEmail, int batchSize, ImportMode importMode) {
        this(CSVImporterDocumentFactory2, dateFormat, listSeparatorRegex, null, escapeCharacter, updateExisting, checkAllowedSubTypes, sendEmail, batchSize, importMode);
    }

    protected CSVImporterOptions(CSVImporterDocumentFactory CSVImporterDocumentFactory2, String dateFormat, String listSeparatorRegex, Character commentMarker, Character escapeCharacter, boolean updateExisting, boolean checkAllowedSubTypes, boolean sendEmail, int batchSize, ImportMode importMode) {
        this.CSVImporterDocumentFactory = CSVImporterDocumentFactory2;
        CSVImporterDocumentFactory2.setImporterOptions(this);
        this.dateFormat = this.computeDateFormat(dateFormat);
        this.listSeparatorRegex = listSeparatorRegex;
        this.commentMarker = commentMarker;
        this.escapeCharacter = escapeCharacter;
        this.updateExisting = updateExisting;
        this.checkAllowedSubTypes = checkAllowedSubTypes;
        this.sendEmail = sendEmail;
        this.batchSize = batchSize;
        this.importMode = importMode;
    }

    protected DateFormat computeDateFormat(String dateFormat) {
        if (dateFormat != null) {
            return new SimpleDateFormat(dateFormat);
        }
        return ((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(LEGACY_DATE_FORMAT_PROP) ? new SimpleDateFormat(LEGACY_DATE_FORMAT) : null;
    }

    public CSVImporterDocumentFactory getCSVImporterDocumentFactory() {
        return this.CSVImporterDocumentFactory;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String getListSeparatorRegex() {
        return this.listSeparatorRegex;
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean updateExisting() {
        return this.updateExisting;
    }

    public boolean checkAllowedSubTypes() {
        return this.checkAllowedSubTypes;
    }

    public boolean sendEmail() {
        return this.sendEmail;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public static enum ImportMode {
        CREATE,
        IMPORT;

    }

    public static class Builder {
        private CSVImporterDocumentFactory CSVImporterDocumentFactory = new DefaultCSVImporterDocumentFactory();
        private String dateFormat;
        private String listSeparatorRegex = "\\|";
        private Character commentMarker;
        private Character escapeCharacter = Character.valueOf('\\');
        private boolean updateExisting = true;
        private boolean checkAllowedSubTypes = true;
        private boolean sendEmail;
        private int batchSize = 50;
        private ImportMode importMode = ImportMode.CREATE;

        public Builder documentModelFactory(CSVImporterDocumentFactory factory) {
            this.CSVImporterDocumentFactory = factory;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder listSeparatorRegex(String listSeparatorRegex) {
            this.listSeparatorRegex = listSeparatorRegex;
            return this;
        }

        public Builder commentMarker(Character commentMarker) {
            this.commentMarker = commentMarker;
            return this;
        }

        public Builder escapeCharacter(Character escapeCharacter) {
            this.escapeCharacter = escapeCharacter;
            return this;
        }

        public Builder updateExisting(boolean updateExisting) {
            this.updateExisting = updateExisting;
            return this;
        }

        public Builder checkAllowedSubTypes(boolean checkAllowedSubTypes) {
            this.checkAllowedSubTypes = checkAllowedSubTypes;
            return this;
        }

        public Builder sendEmail(boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder importMode(ImportMode importMode) {
            this.importMode = importMode;
            return this;
        }

        public CSVImporterOptions build() {
            return new CSVImporterOptions(this.CSVImporterDocumentFactory, this.dateFormat, this.listSeparatorRegex, this.commentMarker, this.escapeCharacter, this.updateExisting, this.checkAllowedSubTypes, this.sendEmail, this.batchSize, this.importMode);
        }
    }
}

