/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.custom.page.providers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.fetcher.VcsFetcher;
import org.nuxeo.elasticsearch.provider.ElasticSearchNxqlPageProvider;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.WrapperQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.filter.Filter;
import org.opensearch.search.builder.SearchSourceBuilder;

public class VectorSearchPageProvider
extends ElasticSearchNxqlPageProvider {
    public static final String RELEVANCE_SCORE = "relevance_score";
    private static final Logger log = LogManager.getLogger(VectorSearchPageProvider.class);

    public List<DocumentModel> getCurrentPage() {
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        DocumentModel searchDoc = this.getSearchDocumentModel();
        if (searchDoc == null) {
            return this.getEmptyResult();
        }
        Map namedParameters = (Map)((Object)searchDoc.getContextData("namedParameters"));
        if (namedParameters == null) {
            return super.getCurrentPage();
        }
        String index = (String)namedParameters.get("vector_index");
        String vector = (String)namedParameters.get("vector_value");
        String inputText = (String)namedParameters.get("input_text");
        if (index == null && vector == null && inputText == null) {
            return super.getCurrentPage();
        }
        this.error = null;
        this.errorMessage = null;
        this.currentPageDocuments = new ArrayList();
        CoreSession coreSession = this.getCoreSession();
        if (this.query == null) {
            this.buildQuery(coreSession);
        }
        if (this.query == null) {
            throw new NuxeoException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
        }
        NxQueryBuilder nxQuery = new NxQueryBuilder(coreSession).nxql(this.query).addAggregates(this.buildAggregates());
        if (StringUtils.isBlank((CharSequence)vector)) {
            if (StringUtils.isBlank((CharSequence)inputText)) {
                return this.getEmptyResult();
            }
            String chainName = (String)namedParameters.get("embedding_automation_processor");
            AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
            OperationContext ctx = new OperationContext(coreSession);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("input_text", inputText);
            try {
                vector = (String)automationService.run(ctx, chainName, params);
            }
            catch (OperationException e) {
                throw new NuxeoException((Throwable)e);
            }
            if (StringUtils.isBlank((CharSequence)vector)) {
                return this.getEmptyResult();
            }
        }
        float minScore = Float.parseFloat(namedParameters.getOrDefault("min_score", "0.4"));
        if (StringUtils.isBlank((CharSequence)index) || StringUtils.isBlank((CharSequence)vector)) {
            return this.getEmptyResult();
        }
        WrapperQueryBuilder queryBuilder = QueryBuilders.wrapperQuery((String)String.format("{\n    \"knn\": {\n        \"%s\": {\n            \"vector\": %s,\n            \"k\": %s\n         }\n    }\n}\n", namedParameters.get("vector_index"), vector, namedParameters.getOrDefault("k", "10")));
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).from(nxQuery.getOffset()).minScore(minScore);
        QueryBuilder nxqlPostFilter = nxQuery.makeQuery();
        QueryBuilder aggregatePostFilter = this.getAggregateFilter(nxQuery);
        BoolQueryBuilder postFilter = QueryBuilders.boolQuery().must(nxqlPostFilter);
        if (aggregatePostFilter != null) {
            postFilter.must(aggregatePostFilter);
        }
        searchSourceBuilder.postFilter((QueryBuilder)postFilter);
        for (AbstractAggregationBuilder aggregate : nxQuery.getEsAggregates()) {
            searchSourceBuilder.aggregation((AggregationBuilder)aggregate);
        }
        searchRequest.source(searchSourceBuilder);
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        ESClient client = esa.getClient();
        SearchResponse response = client.search(searchRequest);
        VcsFetcher fetcher = new VcsFetcher(this.getCoreSession(), response, null);
        SearchHits hits = response.getHits();
        DocumentModelListImpl documents = fetcher.fetchDocuments();
        ArrayList<DocumentModel> result = new ArrayList<DocumentModel>();
        for (SearchHit hit : hits.getHits()) {
            Optional<DocumentModel> documentOpt = documents.stream().filter(doc -> doc.getId().equals(hit.getId())).findFirst();
            documentOpt.ifPresent(doc -> {
                doc.putContextData(RELEVANCE_SCORE, (Serializable)Float.valueOf(hit.getScore()));
                result.add((DocumentModel)doc);
            });
        }
        this.currentPageDocuments = result;
        this.currentAggregates = new HashMap(this.getResultAggregates(nxQuery, response).size());
        for (Aggregate aggregate : this.getResultAggregates(nxQuery, response)) {
            this.currentAggregates.put(aggregate.getId(), aggregate);
        }
        this.setResultsCount(result.size());
        return result;
    }

    public DocumentModelList getEmptyResult() {
        this.setResultsCount(0L);
        return new DocumentModelListImpl();
    }

    public List<Aggregate<Bucket>> getResultAggregates(NxQueryBuilder queryBuilder, SearchResponse response) {
        for (AggregateEsBase agg : queryBuilder.getAggregates()) {
            Aggregation aggregation;
            Filter filter = (Filter)response.getAggregations().get(NxQueryBuilder.getAggregateFilterId((Aggregate)agg));
            if (filter == null || (aggregation = filter.getAggregations().get(agg.getId())) == null) continue;
            agg.parseAggregation(aggregation);
        }
        List ret = queryBuilder.getAggregates();
        return ret;
    }

    public QueryBuilder getAggregateFilter(NxQueryBuilder builder) {
        BoolQueryBuilder ret = QueryBuilders.boolQuery();
        for (AggregateEsBase agg : builder.getAggregates()) {
            QueryBuilder filter = agg.getEsFilter();
            if (filter == null) continue;
            ret.must(filter);
        }
        if (!ret.hasClauses()) {
            return null;
        }
        return ret;
    }
}

