/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.custom.page.providers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.runtime.api.Framework;

public class MultiNuxeoAppsPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    private static final long serialVersionUID = -8773839665513784995L;
    public static final String MULTI_APPS_CONFIG_PARAM = "multi.nuxeo.apps.search";
    protected static List<NuxeoApp> nuxeoApps = null;

    protected void loadNuxeoApps() {
        if (nuxeoApps == null) {
            nuxeoApps = new ArrayList<NuxeoApp>();
            String config = Framework.getProperty((String)MULTI_APPS_CONFIG_PARAM);
            JSONArray nuxeoAppsJson = new JSONArray(config);
            for (int i = 0; i < nuxeoAppsJson.length(); ++i) {
                JSONObject obj = nuxeoAppsJson.getJSONObject(i);
                nuxeoApps.add(new NuxeoApp(obj));
            }
        }
    }

    public List<DocumentModel> getCurrentPage() {
        DocumentModelListImpl docs = new DocumentModelListImpl();
        JSONArray finalresult = new JSONArray();
        DocumentModel searchDoc = this.getSearchDocumentModel();
        if (searchDoc == null) {
            return this.getEmptyResult();
        }
        Map namedParameters = (Map)((Object)searchDoc.getContextData("namedParameters"));
        String fulltextSearchValues = (String)namedParameters.get("fulltextSearchValues");
        String overrideNXQL = (String)namedParameters.get("overrideNXQL");
        nuxeoApps.forEach(oneApp -> {
            JSONObject result = oneApp.call(fulltextSearchValues, overrideNXQL);
            finalresult.put((Object)result);
        });
        return docs;
    }

    public DocumentModelList getEmptyResult() {
        this.setResultsCount(0L);
        return new DocumentModelListImpl();
    }

    protected class NuxeoApp {
        public String appName;
        public String appUrl;
        public String basicUser;
        public String basicPwd;

        public NuxeoApp(JSONObject obj) {
            this.appName = obj.getString("appName");
            this.appUrl = obj.getString("appUrl");
            this.basicUser = obj.getString("basicUser");
            this.basicPwd = obj.getString("basicPwd");
        }

        public JSONObject call(String fulltextSearchValues, String overrideNXQL) {
            Object nxql;
            JSONObject result = null;
            HttpURLConnection connection = null;
            String targetUrl = this.appUrl + "/api/v1/search/lang/NXQL/execute";
            if (StringUtils.isNotBlank((CharSequence)overrideNXQL)) {
                nxql = overrideNXQL;
            } else {
                nxql = "SELECT * FROM Document WHERE ecm:fulltext='" + fulltextSearchValues + "'";
                nxql = (String)nxql + " AND ecm:isVersion = 0 AND ecm:isProxy = 0 AND ecm:isTrashed = 0";
                nxql = (String)nxql + " AND ecm:mixinType != 'HiddenInNavigation'";
            }
            try {
                String encodedNxql = URLEncoder.encode((String)nxql, "UTF-8");
                targetUrl = targetUrl + "?query=" + encodedNxql;
                URL url = new URL(targetUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                String auth = this.basicUser + ":" + this.basicPwd;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
                connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("enrichers.document", "thumbnail");
                connection.setRequestProperty("properties", "dublincore,file,uid");
                int status = connection.getResponseCode();
                if (status == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    result = new JSONObject(response.toString());
                    JSONArray entries = result.getJSONArray("entries");
                    for (int i = 0; i < entries.length(); ++i) {
                        JSONObject oneDoc = entries.getJSONObject(i);
                        oneDoc.put("docFullUrl", (Object)(this.appUrl + "/ui/#!/doc/" + oneDoc.getString("uid")));
                        oneDoc.put("appName", (Object)this.appName);
                    }
                    result.put("responseStatus", status);
                } else {
                    result = new JSONObject();
                    result.put("responseStatus", status);
                    result.put("responseMessage", (Object)connection.getResponseMessage());
                }
                connection.disconnect();
                connection = null;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
            }
            return result;
        }
    }
}

