/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.custom.page.providers;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.runtime.api.Framework;

public class StringListPageProvider
extends AbstractPageProvider<DocumentModel>
implements PageProvider<DocumentModel> {
    private static final long serialVersionUID = 1L;
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String CURRENT_DOCUMENT_ID_PARAM = "currentDocumentId";
    public static final String XPATH_PROPERTY = "xpath";
    private static final Logger log = LogManager.getLogger(StringListPageProvider.class);

    protected CoreSession getCoreSession() {
        Object session = this.getProperties().get(CORE_SESSION_PROPERTY);
        if (session != null && session instanceof CoreSession) {
            return (CoreSession)session;
        }
        return null;
    }

    protected String getXPath() {
        Object docObj = this.getProperties().get(XPATH_PROPERTY);
        if (docObj != null && docObj instanceof String) {
            return (String)docObj;
        }
        return null;
    }

    public PageSelections<DocumentModel> getCurrentSelectPage() {
        return super.getCurrentSelectPage();
    }

    public DocumentModelList getEmptyResult() {
        this.setResultsCount(0L);
        return new DocumentModelListImpl();
    }

    public List<DocumentModel> getCurrentPage() {
        String[] uuids;
        DocumentModelListImpl docs = new DocumentModelListImpl();
        CoreSession session = this.getCoreSession();
        if (session == null) {
            log.error("No core session available in the context of this PageProvider");
            return this.getEmptyResult();
        }
        DocumentModel searchDoc = this.getSearchDocumentModel();
        if (searchDoc == null) {
            log.error("No SearchDocumentModel found for this PageProvider.");
            return this.getEmptyResult();
        }
        Map namedParameters = (Map)((Object)searchDoc.getContextData("namedParameters"));
        if (namedParameters == null) {
            log.error("No namedParameters, missing the currentDocumentId parameter.");
            return this.getEmptyResult();
        }
        String currentDocumentId = (String)namedParameters.get(CURRENT_DOCUMENT_ID_PARAM);
        if (StringUtils.isBlank((CharSequence)currentDocumentId)) {
            log.error("No currentDocumentId parameter.");
            return this.getEmptyResult();
        }
        IdRef ref = new IdRef(currentDocumentId);
        if (!session.exists((DocumentRef)ref)) {
            throw new NuxeoException("Document does not exist: " + currentDocumentId);
        }
        DocumentModel currentDoc = session.getDocument((DocumentRef)ref);
        String xpath = this.getXPath();
        if (StringUtils.isBlank((CharSequence)xpath)) {
            if (((CollectionManager)Framework.getService(CollectionManager.class)).isCollection(currentDoc)) {
                xpath = "collection:documentIds";
            } else {
                throw new NuxeoException("No xpath provided for this PageProvider, and current document is not a collection.");
            }
        }
        if ((uuids = (String[])currentDoc.getPropertyValue(xpath)) != null && uuids.length > 0) {
            for (String uid : uuids) {
                DocumentModel subDoc = session.getDocument((DocumentRef)new IdRef(uid));
                docs.add((Object)subDoc);
            }
        }
        return docs;
    }
}

