/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating.operations;

import java.io.Serializable;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.ecm.rating.api.LikeStatus;

@Operation(id="Services.CancelLike", category="Services", label="Cancel a like for a document or an activity object", description="Cancel a like for a document or an activity object.One of the 'document' or 'activityObject' must be set.Returns the related LikeStatus once the action is done.")
public class CancelLike {
    public static final String ID = "Services.CancelLike";
    @Context
    protected CoreSession session;
    @Context
    protected LikeService likeService;
    @Param(name="document", required=false)
    protected DocumentModel doc;
    @Param(name="activityId", required=false)
    protected String activityId;

    @OperationMethod
    public Blob run() throws Exception {
        LikeStatus status;
        String username = this.session.getPrincipal().getName();
        if (this.doc != null) {
            this.likeService.cancel(username, this.doc);
            status = this.likeService.getLikeStatus(username, this.doc);
        } else if (this.activityId != null) {
            String activityObject = ActivityHelper.createActivityObject((Serializable)((Object)this.activityId));
            this.likeService.cancel(username, activityObject);
            status = this.likeService.getLikeStatus(username, activityObject);
        } else {
            throw new OperationException("'document' or 'activityId' parameter must be set.");
        }
        JSONObject json = JSONObject.fromObject((Object)status.toMap());
        return Blobs.createBlob((String)json.toString(), (String)"application/json");
    }
}

