/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.converters;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.runtime.api.Framework;

public class MultiOutputPictureConverter
extends CommandLineBasedConverter {
    public static final String SOURCE_FILE_PATH_KEY = "inputFilePath";
    public static final String OUT_DIR_PATH_KEY = "outDirPath";
    public static final String OUTPUTS_KEY = "outputs";
    public static final String OUTPUTS_RESIZES_NAMES_KEY = "outputsResizesNames";
    public static final String OUTPUTS_RESIZES_KEY = "outputsResizes";
    public static final String OUTPUTS_EXTENSIONS_KEY = "outputsExtensions";
    public static final String OUTPUTS_PREFIXES_KEY = "outputsPrefixes";
    public static final String VIEWS_DESCRIPTIONS_KEY = "viewsDescriptions";

    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put(SOURCE_FILE_PATH_KEY, blobHolder.getBlob());
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String tmpDir = this.getTmpDirectory(parameters);
        Path tmpDirPath = tmpDir != null ? Paths.get(tmpDir, new String[0]) : null;
        try {
            Path outDirPath = tmpDirPath != null ? Files.createTempDirectory(tmpDirPath, null, new FileAttribute[0]) : Framework.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
            HashMap<String, String> cmdStringParams = new HashMap<String, String>();
            cmdStringParams.put(OUT_DIR_PATH_KEY, outDirPath.toString());
            String[] outputs = ((String)this.initParameters.get(OUTPUTS_KEY)).split(",");
            String[] outPutsResizesNames = ((String)this.initParameters.get(OUTPUTS_RESIZES_NAMES_KEY)).split(",");
            String[] outPutsResizes = ((String)this.initParameters.get(OUTPUTS_RESIZES_KEY)).split(",");
            String[] outPutsExtensions = ((String)this.initParameters.get(OUTPUTS_EXTENSIONS_KEY)).split(",");
            String[] outPutsPrefixes = ((String)this.initParameters.get(OUTPUTS_PREFIXES_KEY)).split(",");
            String sourceFileName = blobHolder.getBlob().getFilename();
            sourceFileName = FilenameUtils.removeExtension((String)sourceFileName);
            for (int i = 0; i < outputs.length; ++i) {
                String targetFileName = outPutsPrefixes[i] + sourceFileName + outPutsExtensions[i];
                Path path = Paths.get(outDirPath.toString(), targetFileName);
                cmdStringParams.put(outputs[i], path.toString());
                cmdStringParams.put(outPutsResizesNames[i], outPutsResizes[i]);
            }
            for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
                cmdStringParams.put(entry.getKey(), (String)((Object)entry.getValue()));
            }
            for (Map.Entry<String, Serializable> entry : this.initParameters.entrySet()) {
                cmdStringParams.put(entry.getKey(), (String)((Object)entry.getValue()));
            }
            return cmdStringParams;
        }
        catch (IOException e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) throws ConversionException {
        File[] files;
        String outputPath = cmdParams.getParameter(OUT_DIR_PATH_KEY);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        File outputDir = new File(outputPath);
        if (outputDir.exists() && outputDir.isDirectory() && (files = outputDir.listFiles()) != null) {
            for (File file : files) {
                try {
                    Blob blob = Blobs.createBlob((File)file);
                    blob.setFilename(file.getName());
                    blobs.add(blob);
                }
                catch (IOException e) {
                    throw new ConversionException("Cannot create blob", (Throwable)e);
                }
            }
        }
        return new SimpleCachableBlobHolder(blobs);
    }
}

