/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.listeners;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.labs.dam.converters.workers.PictureMultiConversionWorker;
import org.nuxeo.runtime.api.Framework;

public class CustomPictureViewsGenerationListener
implements EventListener {
    public static final String DISABLE_PICTURE_VIEWS_GENERATION_LISTENER = "disablePictureViewsGenerationListener";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        Boolean block = (Boolean)event.getContext().getProperty(DISABLE_PICTURE_VIEWS_GENERATION_LISTENER);
        if (Boolean.TRUE.equals(block)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture") && !doc.isVersion() && !doc.isProxy()) {
            PictureMultiConversionWorker work = new PictureMultiConversionWorker(doc.getRepositoryName(), doc.getId(), "file:content");
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            workManager.schedule((Work)work, WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
        }
    }
}

