/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.workers;

import java.util.HashMap;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.labs.dam.converters.workers.PictureMultiConversionWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BigPictureMultiConversionWorker
extends PictureMultiConversionWorker {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY = "bigPictureViewsGeneration";

    public BigPictureMultiConversionWorker(String repositoryName, String docId, String xpath) {
        super(repositoryName, docId, xpath);
    }

    @Override
    public String getCategory() {
        return CATEGORY;
    }

    @Override
    public String getTitle() {
        return "Big Picture Views Generation";
    }

    @Override
    public void work() {
        BlobHolder result;
        ImageInfo imageInfo;
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        this.openSystemSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Document does not exist");
            return;
        }
        DocumentModel workingDocument = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        Property fileProp = workingDocument.getProperty(this.xpath);
        Blob blob = (Blob)fileProp.getValue();
        if (blob == null) {
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.setStatus("Running conversions");
        try {
            imageInfo = this.getImageInfo(blob);
            ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
            result = conversionService.convert("MultiOutputPictureResize", (BlobHolder)new SimpleBlobHolder(blob), new HashMap());
        }
        catch (Exception e) {
            throw new NuxeoException((Throwable)e);
        }
        finally {
            TransactionHelper.startTransaction();
        }
        this.updateDocument(imageInfo, result, workingDocument);
        TransactionHelper.commitOrRollbackTransaction();
        this.closeSession();
        this.setStatus("Done");
    }
}

