/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.workers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.labs.dam.converters.workers.BigPictureMultiConversionWorker;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PictureMultiConversionWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY_PICTURE_GENERATION = "pictureViewsGeneration";
    public static final String PICTURE_VIEWS_GENERATION_DONE_EVENT = "pictureViewsGenerationDone";
    public static final String CONVERTER_NAME = "MultiOutputPictureResize";
    public static final long BILLION = 1000000000L;
    protected static List<String> CONVERTER_PREFIXES = null;
    protected static List<String> CONVERTER_DESCRIPTIONS = null;
    protected final String xpath;

    public PictureMultiConversionWorker(String repositoryName, String docId, String xpath) {
        super(repositoryName + ':' + docId + ':' + xpath + ":pictureView");
        this.setDocument(repositoryName, docId);
        this.xpath = xpath;
    }

    public String getCategory() {
        return CATEGORY_PICTURE_GENERATION;
    }

    public String getTitle() {
        return "Picture views generation";
    }

    protected void buildConverterInfo() {
        if (CONVERTER_PREFIXES == null) {
            CONVERTER_PREFIXES = new ArrayList<String>();
            CONVERTER_DESCRIPTIONS = new ArrayList<String>();
            ConverterDescriptor desc = ConversionServiceImpl.getConverterDescriptor((String)CONVERTER_NAME);
            Map params = desc.getParameters();
            String[] prefixes = ((String)params.get("outputsPrefixes")).split(",");
            CONVERTER_PREFIXES = new ArrayList<String>(Arrays.asList(prefixes));
            for (int i = 0; i < CONVERTER_PREFIXES.size(); ++i) {
                String noUnderscore = StringUtils.removeEnd((String)CONVERTER_PREFIXES.get(i), (String)"_");
                CONVERTER_PREFIXES.set(i, noUnderscore);
            }
            String[] descriptions = ((String)params.get("viewsDescriptions")).split(",");
            CONVERTER_DESCRIPTIONS = new ArrayList<String>(Arrays.asList(descriptions));
        }
    }

    protected List<String> getConverterPrefixes() {
        this.buildConverterInfo();
        return CONVERTER_PREFIXES;
    }

    protected List<String> getConverterDescriptions() {
        this.buildConverterInfo();
        return CONVERTER_DESCRIPTIONS;
    }

    public void work() {
        ImageInfo imageInfo;
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        this.openSystemSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Document does not exist");
            return;
        }
        DocumentModel workingDocument = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        Property fileProp = workingDocument.getProperty(this.xpath);
        Blob blob = (Blob)fileProp.getValue();
        if (blob == null) {
            return;
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.setStatus("Running conversions");
        BlobHolder result = null;
        try {
            imageInfo = this.getImageInfo(blob);
            if (this.isBigImageFile(imageInfo, blob)) {
                BigPictureMultiConversionWorker worker = new BigPictureMultiConversionWorker(this.repositoryName, this.docId, this.xpath);
                WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
                wm.schedule((Work)worker);
            } else {
                ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
                result = conversionService.convert(CONVERTER_NAME, (BlobHolder)new SimpleBlobHolder(blob), new HashMap());
            }
        }
        catch (Exception e) {
            throw new NuxeoException("Could not transcode image file in " + workingDocument.getPath(), (Throwable)e);
        }
        finally {
            TransactionHelper.startTransaction();
        }
        if (result != null) {
            this.updateDocument(imageInfo, result, workingDocument);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.closeSession();
        this.setStatus("Done");
    }

    protected ImageInfo getImageInfo(Blob blob) {
        try {
            BinaryMetadataService service = (BinaryMetadataService)Framework.getService(BinaryMetadataService.class);
            Map metadata = service.readMetadata(blob, true);
            HashMap<String, Serializable> info = new HashMap<String, Serializable>();
            info.put("width", this.getLongValue(metadata.get("ImageWidth")));
            info.put("height", this.getLongValue(metadata.get("ImageHeight")));
            info.put("colorSpace", (Serializable)metadata.get("ColorMode"));
            info.put("format", (Serializable)metadata.get("FileType"));
            Object bitDepth = metadata.get("BitDepth");
            if (bitDepth != null) {
                info.put("depth", this.getLongValue(bitDepth));
            } else {
                Object bitsPerSample = metadata.get("BitsPerSample");
                if (bitsPerSample != null) {
                    info.put("depth", this.getLongValue(bitsPerSample));
                }
            }
            return ImageInfo.fromMap(info);
        }
        catch (NuxeoException e) {
            ImagingService is = (ImagingService)Framework.getService(ImagingService.class);
            return is.getImageInfo(blob);
        }
    }

    protected Long getLongValue(Object object) {
        if (object instanceof Integer) {
            return Long.valueOf(object.toString());
        }
        return null;
    }

    protected boolean isBigImageFile(ImageInfo imageInfo, Blob blob) {
        return (long)imageInfo.getWidth() * (long)imageInfo.getHeight() > 1000000000L;
    }

    protected void updateDocument(ImageInfo imageInfo, BlobHolder result, DocumentModel workingDocument) {
        List<PictureView> viewList = this.buildViews(result.getBlobs());
        ArrayList<Map> views = new ArrayList<Map>();
        for (PictureView pictureView : viewList) {
            views.add(pictureView.asMap());
        }
        workingDocument.setPropertyValue("picture:info", (Serializable)((Object)imageInfo.toMap()));
        workingDocument.setPropertyValue("picture:views", (Serializable)views);
        this.setStatus("Saving");
        if (workingDocument.isVersion()) {
            workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        this.session.saveDocument(workingDocument);
        this.firePictureViewsGenerationDoneEvent(workingDocument);
    }

    protected List<PictureView> buildViews(List<Blob> blobs) {
        ArrayList<PictureView> pictureViews = new ArrayList<PictureView>();
        ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
        List<String> prefixes = this.getConverterPrefixes();
        block0: for (Blob blob : blobs) {
            String filename = blob.getFilename();
            for (int i = 0; i < prefixes.size(); ++i) {
                String prefix = prefixes.get(i);
                if (!filename.startsWith(prefix)) continue;
                ImageInfo imageInfo = imagingService.getImageInfo(blob);
                PictureViewImpl view = new PictureViewImpl();
                view.setTitle(prefix);
                view.setBlob(blob);
                view.setHeight(imageInfo.getHeight());
                view.setWidth(imageInfo.getWidth());
                view.setDescription(this.getConverterDescriptions().get(i));
                view.setImageInfo(imageInfo);
                view.setFilename(blob.getFilename());
                pictureViews.add((PictureView)view);
                continue block0;
            }
        }
        Collections.sort(pictureViews, Comparator.comparingInt(PictureView::getHeight));
        return pictureViews;
    }

    protected void firePictureViewsGenerationDoneEvent(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_PICTURE_GENERATION, null);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.equals(this.getId()) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(PICTURE_VIEWS_GENERATION_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

