/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.converters;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.video.convert.ScreenshotConverter;
import org.nuxeo.labs.dam.converters.BlobHelper;
import org.nuxeo.runtime.api.Framework;

public class StreamVideoScreenshotConverter
extends ScreenshotConverter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        BlobHolder blobHolder2;
        block11: {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CmdParameters params = cles.getDefaultCmdParameters();
            Blob blob = blobHolder.getBlob();
            String uriStr = BlobHelper.getDirectUrl(blob);
            if (uriStr != null) {
                params.addNamedParameter("inFilePath", uriStr);
                try {
                    return this.process(parameters, params);
                }
                catch (IOException | CommandException | CommandNotAvailable e) {
                    throw new ConversionException(e);
                }
            }
            CloseableFile source = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
            try {
                params.addNamedParameter("inFilePath", source.getFile().getAbsolutePath());
                blobHolder2 = this.process(parameters, params);
                if (source == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CommandException | CommandNotAvailable e) {
                    throw new ConversionException(e);
                }
            }
            source.close();
        }
        return blobHolder2;
    }

    protected BlobHolder process(Map<String, Serializable> parameters, CmdParameters params) throws CommandException, CommandNotAvailable, IOException {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        Blob outBlob = Blobs.createBlobWithExtension((String)".jpeg");
        params.addNamedParameter("outFilePath", outBlob.getFile().getAbsolutePath());
        Double position = 0.0;
        if (parameters != null && (position = (Double)parameters.get("position")) == null) {
            position = 0.0;
        }
        long positionParam = Math.round(position);
        params.addNamedParameter("position", String.valueOf(positionParam));
        ExecResult res = cles.execCommand("ffmpeg-screenshot", params);
        if (!res.isSuccessful()) {
            throw res.getError();
        }
        outBlob.setMimeType("image/jpeg");
        outBlob.setFilename(String.format("video-screenshot-%05d.000.jpeg", positionParam));
        return new SimpleCachableBlobHolder(outBlob);
    }
}

