/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.listeners;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.listener.PictureChangedListener;
import org.nuxeo.runtime.api.Framework;

public class OptimizedPictureChangedListener
extends PictureChangedListener {
    public static final String GENERATE_PICTURE_VIEW_EVENT = "generatePictureView";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture") && !doc.isProxy() && this.triggersPictureViewsGeneration(event, doc)) {
            this.preFillPictureViews(docCtx.getCoreSession(), doc);
            Boolean block = (Boolean)event.getContext().getProperty("disablePictureViewsGenerationListener");
            if (block == null || Boolean.FALSE.equals(block)) {
                CoreSession session = doc.getCoreSession();
                this.fireEvent(session, doc);
            }
        }
    }

    protected boolean triggersPictureViewsGeneration(Event event, DocumentModel doc) {
        Property fileProp = doc.getProperty("file:content");
        Property viewsProp = doc.getProperty("picture:views");
        boolean forceGeneration = Boolean.TRUE.equals(doc.getContextData("forceViewsGeneration"));
        boolean emptyPictureViews = viewsProp.size() == 0;
        boolean emptyOrNotDirtyPictureViews = !viewsProp.isDirty() || emptyPictureViews;
        boolean fileChanged = "documentCreated".equals(event.getName()) || fileProp.isDirty();
        return forceGeneration || emptyOrNotDirtyPictureViews && fileChanged;
    }

    protected void fireEvent(CoreSession session, DocumentModel document) {
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), document);
        Event event = ctx.newEvent(GENERATE_PICTURE_VIEW_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

