/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.bulk;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.recompute.RecomputeViewsAction;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;

public class OptimizedRecomputeViewsAction
extends RecomputeViewsAction {
    private static final Logger log = LogManager.getLogger(OptimizedRecomputeViewsAction.class);
    public static final String CONVERTER_NAME = "MultiOutputPictureResize";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(OptimizedRecomputeViewsComputation::new, Arrays.asList("i1:bulk/recomputeViews", "o1:bulk/status")).build();
    }

    public static class OptimizedRecomputeViewsComputation
    extends RecomputeViewsAction.RecomputeViewsComputation {
        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            log.debug("Compute action: {} for doc ids: {}", (Object)"recomputeViews", ids);
            for (String docId : ids) {
                this.pictureViewsHelper.newTransaction();
                DocumentModel workingDocument = session.getDocument((DocumentRef)new IdRef(docId));
                Property fileProp = workingDocument.getProperty(this.xpath);
                Blob blob = (Blob)fileProp.getValue();
                if (blob == null) {
                    return;
                }
                ImageInfo imageInfo = this.getImageInfo(blob);
                ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
                BlobHolder result = conversionService.convert(OptimizedRecomputeViewsAction.CONVERTER_NAME, (BlobHolder)new SimpleBlobHolder(blob), new HashMap());
                this.updateDocument(imageInfo, result, workingDocument, session);
                this.fireEvent(session, session.getDocument((DocumentRef)new IdRef(docId)), "pictureViewsGenerationDone");
            }
        }

        protected void updateDocument(ImageInfo imageInfo, BlobHolder result, DocumentModel workingDocument, CoreSession session) {
            List<PictureView> viewList = this.buildViews(workingDocument, result.getBlobs());
            ArrayList<Map> views = new ArrayList<Map>();
            for (PictureView pictureView : viewList) {
                views.add(pictureView.asMap());
            }
            workingDocument.setPropertyValue("picture:info", (Serializable)((Object)imageInfo.toMap()));
            workingDocument.setPropertyValue("picture:views", (Serializable)views);
            if (workingDocument.isVersion()) {
                workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
            workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
            workingDocument.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
            workingDocument.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
            session.saveDocument(workingDocument);
        }

        protected ImageInfo getImageInfo(Blob blob) {
            ImagingService is = (ImagingService)Framework.getService(ImagingService.class);
            return is.getImageInfo(blob);
        }

        protected List<PictureView> buildViews(DocumentModel workingDocument, List<Blob> blobs) {
            ArrayList<PictureView> pictureViews = new ArrayList<PictureView>();
            ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
            List conversionList = imagingService.getPictureConversions();
            Map<String, PictureConversion> conversionMap = conversionList.stream().collect(Collectors.toMap(PictureConversion::getId, x -> x));
            MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            String basename = FilenameUtils.getBaseName((String)workingDocument.getTitle());
            for (Blob blob : blobs) {
                String id;
                PictureConversion conversion;
                String filename = blob.getFilename();
                int index = filename.indexOf("Output");
                if (index <= 0 || (conversion = conversionMap.get(id = filename.substring(0, index))) == null) continue;
                PictureViewImpl view = new PictureViewImpl();
                ImageInfo imageInfo = imagingService.getImageInfo(blob);
                String extension = FilenameUtils.getExtension((String)blob.getFilename());
                String mimetype = registry.getMimetypeFromExtension(extension);
                blob.setMimeType(mimetype);
                blob.setFilename(String.format("%s_%s.%s", basename, id.toLowerCase(), extension));
                view.setTitle(id);
                view.setBlob(blob);
                view.setHeight(imageInfo.getHeight());
                view.setWidth(imageInfo.getWidth());
                view.setDescription(conversion.getDescription());
                view.setImageInfo(imageInfo);
                view.setFilename(blob.getFilename());
                pictureViews.add((PictureView)view);
            }
            pictureViews.sort(Comparator.comparingInt(PictureView::getHeight));
            return pictureViews;
        }
    }
}

