/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.converters;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.convert.VideoConversionConverter;
import org.nuxeo.labs.dam.converters.BlobHelper;

public class StreamVideoConversionConverter
extends VideoConversionConverter {
    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> stringSerializableMap) throws ConversionException {
        Blob blob = blobHolder.getBlob();
        String uriStr = BlobHelper.getDirectUrl(blob);
        if (uriStr == null) {
            HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
            cmdBlobParams.put("inFilePath", blob);
            return cmdBlobParams;
        }
        return null;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        File outFile;
        String baseDir;
        Path tmpPath;
        File outDir;
        boolean dirCreated;
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        Blob blob = blobHolder.getBlob();
        String uriStr = BlobHelper.getDirectUrl(blob);
        if (uriStr != null) {
            cmdStringParams.put("inFilePath", uriStr);
        }
        if (!(dirCreated = (outDir = new File((tmpPath = new Path(baseDir = this.getTmpDirectory(parameters)).append(this.getTmpDirectoryPrefix() + "_" + UUID.randomUUID())).toString())).mkdir())) {
            throw new ConversionException("Unable to create tmp dir for transformer output: " + outDir);
        }
        try {
            outFile = File.createTempFile("videoConversion", this.getVideoExtension(), outDir);
        }
        catch (IOException e) {
            throw new ConversionException("Unable to get Blob for holder", (Throwable)e);
        }
        outFile.delete();
        cmdStringParams.put("outFilePath", outFile.getAbsolutePath());
        String baseName = FilenameUtils.getBaseName((String)blobHolder.getBlob().getFilename());
        cmdStringParams.put("outFileName", baseName + this.getVideoExtension());
        VideoInfo videoInfo = (VideoInfo)parameters.get("videoInfo");
        if (videoInfo == null) {
            return cmdStringParams;
        }
        long width = videoInfo.getWidth();
        long height = videoInfo.getHeight();
        long newHeight = (Long)parameters.get("height");
        long newWidth = width * newHeight / height;
        if (newWidth % 2L != 0L) {
            ++newWidth;
        }
        cmdStringParams.put("converterTmpPath", outDir.getAbsolutePath());
        cmdStringParams.put("width", String.valueOf(newWidth));
        cmdStringParams.put("height", String.valueOf(newHeight));
        return cmdStringParams;
    }
}

