/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.dam.converters.converters;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.video.convert.StoryboardConverter;
import org.nuxeo.labs.dam.converters.BlobHelper;
import org.nuxeo.runtime.api.Framework;

public class StreamVideoStoryboardConverter
extends StoryboardConverter {
    private static final Logger log = LogManager.getLogger(StreamVideoStoryboardConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        BlobHolder blobHolder2;
        block11: {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CmdParameters params = cles.getDefaultCmdParameters();
            Blob blob = blobHolder.getBlob();
            String uriStr = BlobHelper.getDirectUrl(blob);
            if (uriStr != null) {
                params.addNamedParameter("inFilePath", uriStr);
                try {
                    return this.process(parameters, params, blob);
                }
                catch (IOException | CommandException | CommandNotAvailable e) {
                    throw new ConversionException(e);
                }
            }
            CloseableFile source = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
            try {
                params.addNamedParameter("inFilePath", source.getFile().getAbsolutePath());
                blobHolder2 = this.process(parameters, params, blob);
                if (source == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CommandException | CommandNotAvailable e) {
                    throw new ConversionException(e);
                }
            }
            source.close();
        }
        return blobHolder2;
    }

    protected BlobHolder process(Map<String, Serializable> parameters, CmdParameters params, Blob blob) throws CommandException, CommandNotAvailable, IOException {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        ArrayList<Double> timecodes = new ArrayList<Double>();
        ArrayList<String> comments = new ArrayList<String>();
        properties.put("timecodes", timecodes);
        properties.put("comments", comments);
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties(blobs, properties);
        Double duration = (Double)parameters.get("duration");
        if (duration == null) {
            log.warn(String.format("Cannot extract storyboard for file '%s' with missing duration info.", blob.getFilename()));
            return bh;
        }
        int numberOfThumbnails = this.getNumberOfThumbnails(parameters);
        for (int i = 0; i < numberOfThumbnails; ++i) {
            double timecode = BigDecimal.valueOf((double)i * duration / (double)numberOfThumbnails).setScale(2, RoundingMode.HALF_UP).doubleValue();
            Blob thumbBlob = Blobs.createBlobWithExtension((String)".jpeg");
            params.addNamedParameter("outFilePath", thumbBlob.getFile().getAbsolutePath());
            params.addNamedParameter("position", String.valueOf(timecode));
            this.fillWidthAndHeightParameters(params, parameters);
            ExecResult result = cles.execCommand("ffmpeg-screenshot-resize", params);
            if (!result.isSuccessful()) {
                throw result.getError();
            }
            thumbBlob.setMimeType("image/jpeg");
            thumbBlob.setFilename(String.format(Locale.ENGLISH, "%.2f-seconds.jpeg", timecode));
            blobs.add(thumbBlob);
            timecodes.add(timecode);
            comments.add(String.format("%s %d", blob.getFilename(), i));
        }
        return bh;
    }
}

