/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.pdf.export;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;

public class PDFCreator {
    private static Font font = new Font(1, 18.0f, 1);
    private static final String PICTURE_SCHEMA = "picture";
    private static final String ORIGINAL_JPEG_VIEW = "OriginalJpeg";
    protected List<DocumentModel> docs;
    protected NuxeoPrincipal currentUser;

    public PDFCreator(List<DocumentModel> docs, NuxeoPrincipal currentUser) {
        this.docs = docs;
        this.currentUser = currentUser;
    }

    public boolean createPDF(String title, OutputStream out) throws ClientException {
        try {
            Document document = new Document();
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.addTitle(title);
            document.addAuthor(Functions.principalFullName((NuxeoPrincipal)this.currentUser));
            document.addCreator(Functions.principalFullName((NuxeoPrincipal)this.currentUser));
            document.open();
            document.add((Element)new Paragraph("\n\n\n\n\n\n\n\n\n\n"));
            Font titleFont = new Font(1, 36.0f, 1);
            Paragraph titleParagraph = new Paragraph(title, titleFont);
            titleParagraph.setAlignment(1);
            document.add((Element)titleParagraph);
            Font authorFont = new Font(1, 20.0f);
            Paragraph authorParagraph = new Paragraph("By " + Functions.principalFullName((NuxeoPrincipal)this.currentUser), authorFont);
            authorParagraph.setAlignment(1);
            document.add((Element)authorParagraph);
            document.newPage();
            boolean foundOnePicture = false;
            for (DocumentModel doc : this.docs) {
                if (!doc.hasSchema(PICTURE_SCHEMA)) continue;
                foundOnePicture = true;
                PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
                Blob blob = picture.getPictureFromTitle(ORIGINAL_JPEG_VIEW);
                Rectangle pageSize = document.getPageSize();
                if (blob == null) continue;
                Paragraph imageTitle = new Paragraph(blob.getFilename(), font);
                imageTitle.setAlignment(1);
                document.add((Element)imageTitle);
                Image image = Image.getInstance((byte[])blob.getByteArray());
                image.scaleToFit(pageSize.getWidth() - 20.0f, pageSize.getHeight() - 100.0f);
                image.setAlignment(1);
                Paragraph imageParagraph = new Paragraph();
                imageParagraph.add((Object)image);
                imageParagraph.setAlignment(5);
                document.add((Element)imageParagraph);
                document.newPage();
            }
            if (foundOnePicture) {
                document.close();
                return true;
            }
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        return false;
    }
}

