/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.pdf.export;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.dam.pdf.export.PDFCreator;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="damPdfExportActions")
@Install(precedence=10)
public class PDFExportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected DocumentsListsManager documentsListsManager;
    @In(required=false)
    protected transient Principal currentUser;

    public String exportSelectionAsPDF() throws ClientException {
        try {
            FacesContext context;
            HttpServletResponse response;
            BufferedOutputStream buff;
            if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
                return null;
            }
            List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            PDFCreator creator = new PDFCreator(docs, (NuxeoPrincipal)this.currentUser);
            if (creator.createPDF("PDF Export", buff = new BufferedOutputStream((OutputStream)(response = (HttpServletResponse)(context = FacesContext.getCurrentInstance()).getExternalContext().getResponse()).getOutputStream()))) {
                response.setHeader("Content-Disposition", "attachment; filename=\"PDF export.pdf\";");
                response.setContentType("application/pdf");
                response.flushBuffer();
                context.responseComplete();
            }
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        return null;
    }

    public boolean getCanExportAsPDF() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        for (DocumentModel doc : docs) {
            if (!doc.hasFacet("Picture")) continue;
            return true;
        }
        return false;
    }
}

