/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.service.VideoConversionId;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class VideoConversionTask
implements Runnable {
    private static final Log log = LogFactory.getLog(VideoConversionTask.class);
    private final VideoConversionId id;
    private final DocumentRef docRef;
    private final String repositoryName;
    private final String conversionName;
    private final VideoService service;

    public VideoConversionTask(DocumentModel doc, String conversionName, VideoService service) {
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.conversionName = conversionName;
        this.service = service;
        this.id = new VideoConversionId((DocumentLocation)new DocumentLocationImpl(this.repositoryName, this.docRef), conversionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Video originalVideo = this.getVideoToConvert();
        if (originalVideo != null) {
            try {
                TranscodedVideo transcodedVideo = this.service.convert(this.id, originalVideo, this.conversionName);
                this.saveNewTranscodedVideo(transcodedVideo);
            }
            finally {
                this.service.clearProgressStatus(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Video getVideoToConvert() {
        final ArrayList videos = new ArrayList();
        TransactionHelper.startTransaction();
        try {
            new UnrestrictedSessionRunner(this.repositoryName){

                public void run() throws ClientException {
                    DocumentModel doc = this.session.getDocument(VideoConversionTask.this.docRef);
                    VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
                    Video video = videoDocument.getVideo();
                    if (video != null) {
                        videos.add(video);
                    } else {
                        log.warn((Object)("No original video to transcode for: " + doc));
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            TransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e, (Throwable)e);
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
        return videos.isEmpty() ? null : (Video)videos.get(0);
    }

    private void saveNewTranscodedVideo(final TranscodedVideo transcodedVideo) {
        TransactionHelper.startTransaction();
        try {
            new UnrestrictedSessionRunner(this.repositoryName){

                public void run() throws ClientException {
                    DocumentModel doc = this.session.getDocument(VideoConversionTask.this.docRef);
                    ArrayList<Map<String, Serializable>> transcodedVideos = (ArrayList<Map<String, Serializable>>)doc.getPropertyValue("vid:transcodedVideos");
                    if (transcodedVideos == null) {
                        transcodedVideos = new ArrayList<Map<String, Serializable>>();
                    }
                    transcodedVideos.add(transcodedVideo.toMap());
                    doc.setPropertyValue("vid:transcodedVideos", (Serializable)transcodedVideos);
                    this.session.saveDocument(doc);
                    this.session.save();
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            TransactionHelper.setTransactionRollbackOnly();
            throw new ClientRuntimeException((Throwable)e);
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public VideoConversionId getId() {
        return this.id;
    }
}

