/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.importer.random.RandomTextGenerator;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class RandomTextSourceNode
implements SourceNode {
    protected static RandomTextGenerator gen;
    protected static int maxNode;
    public static int maxDepth;
    public static int defaultNbDataNodesPerFolder;
    protected static int minGlobalFolders;
    protected static int minFoldersPerNode;
    protected static Integer nbNodes;
    protected static Integer nbFolders;
    protected static Long size;
    protected Random hazard;
    protected String name;
    protected boolean folderish;
    protected int level = 0;
    protected int idx = 0;
    protected static Integer blobSizeInKB;
    protected List<SourceNode> cachedChildren = null;
    public static boolean CACHE_CHILDREN;
    protected boolean onlyText = true;

    public RandomTextSourceNode(boolean folderish, int level, int idx, boolean onlyText) {
        this.folderish = folderish;
        this.hazard = new Random(System.currentTimeMillis());
        this.level = level;
        this.idx = idx;
        this.onlyText = onlyText;
    }

    public static RandomTextSourceNode init(int maxSize) throws Exception {
        return RandomTextSourceNode.init(maxSize, null, true);
    }

    public static RandomTextSourceNode init(int maxSize, Integer blobSizeInKB, boolean onlyText) throws Exception {
        gen = new RandomTextGenerator();
        gen.prefilCache();
        maxNode = maxSize;
        nbNodes = 1;
        size = new Long(0L);
        RandomTextSourceNode.blobSizeInKB = blobSizeInKB;
        minGlobalFolders = maxNode / defaultNbDataNodesPerFolder;
        minFoldersPerNode = 1 + (int)Math.pow(minGlobalFolders, 1.0 / (double)maxDepth);
        return new RandomTextSourceNode(true, 0, 0, onlyText);
    }

    protected String getBlobMimeType() {
        if (this.onlyText) {
            return "text/plain";
        }
        return "text/partial";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobHolder getBlobHolder() {
        if (this.folderish) {
            return null;
        }
        String content = null;
        content = blobSizeInKB == null ? gen.getRandomText() : gen.getRandomText(blobSizeInKB);
        Long l = size;
        synchronized (l) {
            size = size + (long)content.length();
        }
        StringBlob blob = new StringBlob(content);
        blob.setFilename(this.getName() + ".txt");
        blob.setMimeType(this.getBlobMimeType());
        return new SimpleBlobHolder((Blob)blob);
    }

    protected int getMidRandom(int target) {
        return 1 + target / 2 + this.hazard.nextInt(target);
    }

    protected int getMaxChildren() {
        if (maxNode < nbNodes) {
            return 0;
        }
        int targetRemainingFolders = minGlobalFolders - nbFolders;
        if (targetRemainingFolders <= 0) {
            return defaultNbDataNodesPerFolder + 1;
        }
        int target = (maxNode - nbNodes) / targetRemainingFolders;
        if (target <= 0) {
            return 0;
        }
        return this.getMidRandom(target);
    }

    protected int getMaxFolderish() {
        if (maxNode <= nbNodes) {
            return 0;
        }
        return this.getMidRandom(minFoldersPerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SourceNode> getChildren() {
        if (!this.folderish) {
            return null;
        }
        if (this.cachedChildren != null) {
            return this.cachedChildren;
        }
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        if (nbNodes > maxNode) {
            return children;
        }
        int nbChildren = this.getMaxChildren();
        Integer n = nbNodes;
        synchronized (n) {
            nbNodes = nbNodes + nbChildren;
        }
        for (int i = 0; i < nbChildren; ++i) {
            children.add(new RandomTextSourceNode(false, this.level, i, this.onlyText));
        }
        if (this.level < maxDepth) {
            int nbFolderish = this.getMaxFolderish();
            for (int i = 0; i < nbFolderish; ++i) {
                children.add(new RandomTextSourceNode(true, this.level + 1, i, this.onlyText));
            }
            Integer n2 = nbFolders;
            synchronized (n2) {
                nbFolders = nbFolders + nbFolderish;
            }
        }
        if (CACHE_CHILDREN) {
            this.cachedChildren = children;
        }
        return children;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.folderish ? "folder" : "file";
            this.name = this.level == 0 && this.folderish ? this.name + "-" + System.currentTimeMillis() % 10000L + this.hazard.nextInt(100) : this.name + "-" + this.level + "-" + this.idx;
        }
        return this.name;
    }

    @Override
    public boolean isFolderish() {
        return this.folderish;
    }

    public static Integer getNbNodes() {
        return nbNodes;
    }

    public static Long getSize() {
        return size;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSourcePath() {
        return null;
    }

    static {
        maxNode = 10000;
        maxDepth = 8;
        defaultNbDataNodesPerFolder = 15;
        minGlobalFolders = 0;
        minFoldersPerNode = 0;
        nbNodes = 1;
        nbFolders = 0;
        CACHE_CHILDREN = false;
    }
}

