/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExifHelper {
    public static final Log log = LogFactory.getLog(ExifHelper.class);
    public static final byte[] ASCII = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    public static final byte[] JIS = new byte[]{74, 73, 83, 0, 0, 0, 0, 0};
    public static final byte[] UNDEFINED = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    private ExifHelper() {
    }

    public static String decodeUndefined(byte[] rawBytes) {
        byte[] dataType = ExifHelper.extractBytes(rawBytes, 0, 8);
        if (Arrays.equals(ASCII, dataType)) {
            if (rawBytes.length <= 8) {
                return "";
            }
            return new String(ExifHelper.extractBytes(rawBytes, 8, rawBytes.length - 1));
        }
        if (Arrays.equals(JIS, dataType)) {
            log.warn((Object)"The Japanese data type encoding is not supported yet");
            return "";
        }
        if (Arrays.equals(UNDEFINED, dataType)) {
            log.debug((Object)"Undefined data type encoding");
            return "";
        }
        log.debug((Object)"Unknown data type encoding");
        return "";
    }

    public static byte[] extractBytes(byte[] bytes, int beginIndex, int endIndex) {
        byte[] result = new byte[endIndex - beginIndex];
        int count = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            result[count++] = bytes[i];
        }
        return result;
    }
}

