/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.dam.DamService;
import org.nuxeo.dam.webapp.contentbrowser.DamDocumentActions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.platform.ui.web.api.SortNotSupportedException;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeNode;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="filterActions")
@Install(precedence=10)
public class FilterActions
implements Serializable,
ResultsProviderFarm {
    public static final String DC_COVERAGE_DIRECTORY_TREE = "dcCoverageDirectoryTree";
    public static final String TOPIC_DIRECTORY_TREE = "dcSubjectsDirectoryTree";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FilterActions.class);
    public static final List<String> DAM_DOCUMENT_TYPES = Arrays.asList("File", "Picture", "Video", "Audio");
    public static final String QUERY_MODEL_NAME = "FILTERED_DOCUMENTS";
    public static final String DOCTYPE_FIELD_XPATH = "filter_query:ecm_primaryType";
    public static final String PATH_FIELD_XPATH = "filter_query:ecm_path";
    public static final String ASSET_LIBRARY_PATH_FIELD_XPATH = "filter_query:asset_library_path";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true, required=false)
    transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true)
    protected DirectoryTreeManager directoryTreeManager;
    @In(create=true)
    protected DamDocumentActions damDocumentActions;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @RequestParameter
    protected String docType;
    @RequestParameter
    protected String folderPath;
    protected DocumentModel filterDocument;

    public DocumentModel getFilterDocument() throws ClientException {
        if (this.filterDocument == null) {
            this.filterDocument = this.queryModelActions.get(QUERY_MODEL_NAME).getDocumentModel();
            DamService damService = (DamService)Framework.getLocalService(DamService.class);
            this.filterDocument.setPropertyValue(ASSET_LIBRARY_PATH_FIELD_XPATH, (Serializable)((Object)damService.getAssetLibraryPath()));
        }
        return this.filterDocument;
    }

    @Factory(value="docTypeSelectItems", scope=ScopeType.EVENT)
    public List<SelectItem> getDocTypeSelectItems() throws ClientException {
        DocumentModel filterDocument = this.getFilterDocument();
        List docTypeSelection = (List)filterDocument.getProperty(DOCTYPE_FIELD_XPATH).getValue(List.class);
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        items.add(new SelectItem((Object)"All", "label.type.All", "", docTypeSelection.isEmpty()));
        for (String type : DAM_DOCUMENT_TYPES) {
            items.add(new SelectItem((Object)type, "label.type." + type, "", docTypeSelection.contains(type)));
        }
        return items;
    }

    public void toggleSelectDocType() throws ClientException {
        DocumentModel filterDocument = this.getFilterDocument();
        List previousSelection = (List)filterDocument.getProperty(DOCTYPE_FIELD_XPATH).getValue(List.class);
        if ("All".equalsIgnoreCase(this.docType)) {
            previousSelection.clear();
        } else if (previousSelection.contains(this.docType)) {
            previousSelection.remove(this.docType);
        } else {
            previousSelection.add(this.docType);
            if (previousSelection.size() == DAM_DOCUMENT_TYPES.size()) {
                previousSelection.clear();
            }
        }
        filterDocument.setPropertyValue(DOCTYPE_FIELD_XPATH, (Serializable)((Object)previousSelection));
        this.invalidateProvider();
    }

    public List<DirectoryTreeNode> getCoverageTreeRoots() {
        return this.directoryTreeManager.get(DC_COVERAGE_DIRECTORY_TREE).getChildren();
    }

    public List<DirectoryTreeNode> getTopicTreeRoots() {
        return this.directoryTreeManager.get(TOPIC_DIRECTORY_TREE).getChildren();
    }

    @Factory(value="userImportSetsSelectItems", scope=ScopeType.EVENT)
    public List<SelectItem> getUserImportSetsSelectItems() throws ClientException {
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        String currentUser = this.documentManager.getPrincipal().getName();
        DocumentModelList docs = this.queryModelActions.get("USER_IMPORT_SETS").getDocuments(this.documentManager, new Object[]{damService.getAssetLibraryPath(), currentUser});
        List lastUserImportSets = docs.size() > 2 ? docs.subList(0, 3) : docs;
        DocumentModel filterDocument = this.getFilterDocument();
        String folderSelection = (String)((Object)filterDocument.getPropertyValue(PATH_FIELD_XPATH));
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Iterator i$ = lastUserImportSets.iterator();
        while (i$.hasNext()) {
            DocumentModel doc = (DocumentModel)i$.next();
            String docPath = doc.getPathAsString();
            items.add(new SelectItem((Object)docPath, doc.getTitle(), "", docPath.equals(folderSelection)));
        }
        return items;
    }

    public SelectItem getFolderSelectedItem() throws ClientException {
        DocumentModel filterDocument = this.getFilterDocument();
        String folderSelection = (String)((Object)filterDocument.getPropertyValue(PATH_FIELD_XPATH));
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        if (StringUtils.isBlank((String)folderSelection) || damService.getAssetLibraryPath().equals(folderSelection)) {
            return new SelectItem((Object)"All", (String)this.resourcesAccessor.getMessages().get("label.type.All"), "", false);
        }
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new PathRef(folderSelection));
        return new SelectItem((Object)doc.getPathAsString(), doc.getTitle(), "", false);
    }

    public void toggleSelectFolder() throws ClientException {
        DocumentModel filterDocument = this.getFilterDocument();
        if ("All".equals(this.folderPath)) {
            filterDocument.setPropertyValue(PATH_FIELD_XPATH, null);
        } else {
            filterDocument.setPropertyValue(PATH_FIELD_XPATH, (Serializable)((Object)this.folderPath));
        }
        this.invalidateProvider();
    }

    public PagedDocumentsProvider getResultsProvider(String queryModelName) throws ClientException, ResultsProviderFarmUserException {
        try {
            return this.getResultsProvider(queryModelName, null);
        }
        catch (SortNotSupportedException e) {
            throw new ClientException("unexpected exception", (Throwable)e);
        }
    }

    public PagedDocumentsProvider getResultsProvider(String queryModelName, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        if (!QUERY_MODEL_NAME.equals(queryModelName)) {
            return null;
        }
        QueryModel model = this.queryModelActions.get(queryModelName);
        if (!model.isSortable() && sortInfo != null) {
            throw new SortNotSupportedException();
        }
        if (sortInfo == null) {
            sortInfo = new SortInfo("dc:title", true);
        }
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        PagedDocumentsProvider provider = model.getResultsProvider(this.documentManager, new Object[]{damService.getAssetLibraryPath()}, sortInfo);
        provider.setName(queryModelName);
        DocumentModelList currentPage = provider.getCurrentPage();
        if (currentPage != null && !currentPage.isEmpty()) {
            this.damDocumentActions.setCurrentSelection((DocumentModel)currentPage.get(0));
        } else {
            this.damDocumentActions.setCurrentSelection(null);
        }
        return provider;
    }

    @Observer(value={"queryModelChanged"})
    public void queryModelChanged(QueryModel qm) {
        this.resultsProvidersCache.invalidate(qm.getDescriptor().getName());
    }

    @Observer(value={"documentChildrenChanged", "folderListChanged"})
    public void invalidateProvider() {
        this.resultsProvidersCache.invalidate(QUERY_MODEL_NAME);
    }

    public void clearFilters() throws ClientException {
        this.filterDocument = null;
        this.queryModelActions.get(QUERY_MODEL_NAME).reset();
        this.invalidateProvider();
    }

    public boolean isFolderToHighlight(DocumentTreeNodeImpl node) throws ClientException {
        DocumentModel filterDocument = this.getFilterDocument();
        String folderSelection = (String)((Object)filterDocument.getPropertyValue(PATH_FIELD_XPATH));
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        if (StringUtils.isBlank((String)folderSelection) || damService.getAssetLibraryPath().equals(folderSelection)) {
            return "ImportRoot".equals(node.getDocument().getType());
        }
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new PathRef(folderSelection));
        return node.getDocument().equals(doc);
    }
}

