/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.adapter;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.VideoInfo;

public class VideoDocumentAdapter
implements VideoDocument {
    private final DocumentModel doc;
    private final Video video;
    private Map<String, TranscodedVideo> transcodedVideos;

    public VideoDocumentAdapter(DocumentModel doc) {
        if (!doc.hasFacet("Video")) {
            throw new ClientRuntimeException(doc + " is not a Video document.");
        }
        try {
            this.doc = doc;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            Blob blob = bh.getBlob();
            VideoInfo videoInfo = VideoInfo.fromMap((Map)((Map)((Object)doc.getPropertyValue("vid:info"))));
            this.video = Video.fromBlobAndInfo((Blob)blob, (VideoInfo)videoInfo);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public Video getVideo() {
        return this.video;
    }

    public Collection<TranscodedVideo> getTranscodedVideos() {
        if (this.transcodedVideos == null) {
            this.initTranscodedVideos();
        }
        return this.transcodedVideos.values();
    }

    public TranscodedVideo getTranscodedVideo(String name) {
        if (this.transcodedVideos == null) {
            this.initTranscodedVideos();
        }
        return this.transcodedVideos.get(name);
    }

    private void initTranscodedVideos() {
        try {
            if (this.transcodedVideos == null) {
                List videos = (List)((Object)this.doc.getPropertyValue("vid:transcodedVideos"));
                this.transcodedVideos = Maps.newHashMap();
                for (int i = 0; i < videos.size(); ++i) {
                    TranscodedVideo transcodedVideo = TranscodedVideo.fromMapAndPosition((Map)((Map)videos.get(i)), (int)i);
                    this.transcodedVideos.put(transcodedVideo.getName(), transcodedVideo);
                }
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

