/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.impl.AsyncEventExecutor;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoConversionStatus;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversion;
import org.nuxeo.ecm.platform.video.service.AutomaticVideoConversionContributionHandler;
import org.nuxeo.ecm.platform.video.service.VideoConversion;
import org.nuxeo.ecm.platform.video.service.VideoConversionContributionHandler;
import org.nuxeo.ecm.platform.video.service.VideoConversionId;
import org.nuxeo.ecm.platform.video.service.VideoConversionTask;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class VideoServiceImpl
extends DefaultComponent
implements VideoService {
    private static final Log log = LogFactory.getLog(VideoServiceImpl.class);
    public static final String VIDEO_CONVERSIONS_EP = "videoConversions";
    public static final String DEFAULT_VIDEO_CONVERSIONS_EP = "automaticVideoConversions";
    private VideoConversionContributionHandler videoConversions;
    private AutomaticVideoConversionContributionHandler automaticVideoConversions;
    private BlockingQueue<Runnable> conversionTaskQueue;
    private ThreadPoolExecutor conversionExecutor;
    private final Map<VideoConversionId, String> states = new MapMaker().concurrencyLevel(10).expiration(1L, TimeUnit.DAYS).makeMap();

    public void activate(ComponentContext context) throws Exception {
        this.videoConversions = new VideoConversionContributionHandler();
        this.automaticVideoConversions = new AutomaticVideoConversionContributionHandler();
        AsyncEventExecutor.NamedThreadFactory serializationThreadFactory = new AsyncEventExecutor.NamedThreadFactory("Nuxeo Async Video Conversion");
        this.conversionTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.conversionExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, this.conversionTaskQueue, (ThreadFactory)serializationThreadFactory);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.conversionTaskQueue.clear();
        this.conversionExecutor.shutdownNow();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.videoConversions.addContribution((VideoConversion)contribution);
        } else if (DEFAULT_VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.automaticVideoConversions.addContribution((AutomaticVideoConversion)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.videoConversions.removeContribution((VideoConversion)contribution);
        } else if (DEFAULT_VIDEO_CONVERSIONS_EP.equals(extensionPoint)) {
            this.automaticVideoConversions.removeContribution((AutomaticVideoConversion)contribution);
        }
    }

    public Collection<VideoConversion> getAvailableVideoConversions() {
        return this.videoConversions.registry.values();
    }

    public void launchConversion(DocumentModel doc, String conversionName) {
        VideoConversionTask task = new VideoConversionTask(doc, conversionName, (VideoService)this);
        if (!this.conversionTaskQueue.contains(task)) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(doc.getRepositoryName(), doc.getRef());
            VideoConversionId id = new VideoConversionId((DocumentLocation)docLoc, conversionName);
            this.states.put(id, "status.video.conversionQueued");
            this.conversionExecutor.execute((Runnable)task);
        }
    }

    public void launchAutomaticConversions(DocumentModel doc) {
        ArrayList<AutomaticVideoConversion> conversions = new ArrayList<AutomaticVideoConversion>(this.automaticVideoConversions.registry.values());
        Collections.sort(conversions);
        for (AutomaticVideoConversion conversion : conversions) {
            this.launchConversion(doc, conversion.getName());
        }
    }

    public TranscodedVideo convert(Video originalVideo, String conversionName) {
        return this.convert(null, originalVideo, conversionName);
    }

    public TranscodedVideo convert(VideoConversionId id, Video originalVideo, String conversionName) {
        try {
            if (!this.videoConversions.registry.containsKey(conversionName)) {
                throw new ClientRuntimeException(String.format("'%s' is not a registered video conversion.", conversionName));
            }
            if (id != null) {
                this.states.put(id, "status.video.conversionPending");
            }
            SimpleBlobHolder blobHolder = new SimpleBlobHolder(originalVideo.getBlob());
            VideoConversion conversion = this.videoConversions.registry.get(conversionName);
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("height", conversion.getHeight());
            parameters.put("videoInfo", (Long)originalVideo.getVideoInfo());
            ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
            BlobHolder result = conversionService.convert(conversion.getConverter(), (BlobHolder)blobHolder, parameters);
            VideoInfo videoInfo = VideoHelper.getVideoInfo(result.getBlob());
            return TranscodedVideo.fromBlobAndInfo((String)conversionName, (Blob)result.getBlob(), (VideoInfo)videoInfo);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public VideoConversionStatus getProgressStatus(VideoConversionId id) {
        String status = this.states.get(id);
        if (status == null) {
            return null;
        }
        BlockingQueue<Runnable> q = null;
        if ("status.video.conversionQueued".equals(status)) {
            q = this.conversionTaskQueue;
        }
        int posInQueue = 0;
        int queueSize = 0;
        if (q != null) {
            Object[] queuedItems = q.toArray();
            queueSize = queuedItems.length;
            for (int i = 0; i < queueSize; ++i) {
                if (!((VideoConversionTask)queuedItems[i]).getId().equals((Object)id)) continue;
                posInQueue = i + 1;
                break;
            }
        }
        return new VideoConversionStatus(status, posInQueue, queueSize);
    }

    public void clearProgressStatus(VideoConversionId id) {
        this.states.remove(id);
    }
}

