/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.DrawOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawJ2DOp
extends OperationImplementation<DrawOp, BufferedImage> {
    private static final String CLASS = DrawJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage execute(DrawOp operation, BufferedImage bufferedImage) {
        Graphics2D g = null;
        BufferedImage result = Java2DUtils.createCompatibleImage(bufferedImage, bufferedImage.getWidth(), bufferedImage.getHeight());
        try {
            g = result.createGraphics();
            g.drawImage((Image)bufferedImage, 0, 0, null);
            operation.getExecutor().draw(g);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return result;
    }
}

