/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public abstract class BaseVideoConverter {
    protected CommandLineExecutorService cleService;
    protected static final Pattern DURATION_PATTERN = Pattern.compile("Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+)");

    @Deprecated
    protected static Double extractDuration(List<String> output) throws ConversionException {
        for (String line : output) {
            Matcher matcher = DURATION_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            return Double.parseDouble(matcher.group(1)) * 3600.0 + Double.parseDouble(matcher.group(2)) * 60.0 + Double.parseDouble(matcher.group(3)) + Double.parseDouble(matcher.group(3)) / 100.0;
        }
        throw new ConversionException("failed to extract the duration from output: " + StringUtils.join(output, (String)" "));
    }

    public static String quoteFilePath(String filePath) {
        return String.format("\"%s\"", filePath);
    }

    public static class InputFile {
        public boolean isTempFile;
        public File file;

        public InputFile(Blob blob) throws IOException {
            StreamingBlob streamingBlob;
            StreamSource source;
            if (blob instanceof FileBlob) {
                FileBlob fileBlob = (FileBlob)blob;
                this.file = fileBlob.getFile();
                this.isTempFile = false;
            } else if (blob instanceof StreamingBlob && (source = (streamingBlob = (StreamingBlob)blob).getStreamSource()) instanceof FileSource) {
                FileSource fileSource = (FileSource)source;
                this.file = fileSource.getFile();
                this.isTempFile = false;
            }
            if (this.file == null) {
                this.file = File.createTempFile("StoryboardConverter-in-", "-" + blob.getFilename());
                blob.transferTo(this.file);
                this.isTempFile = true;
            }
        }
    }
}

