/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.core;

import java.io.File;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.dam.importer.core.TargetContainerCreator;
import org.nuxeo.dam.importer.core.helper.UnrestrictedSessionRunnerHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;

public class DamMultiThreadedImporter
extends GenericMultiThreadedImporter {
    protected String importFolderPath;
    protected String importFolderTitle;
    protected String importSetTitle;
    protected boolean removeImportedFolder = false;

    public static DamMultiThreadedImporter createWithImportFolderPath(ImporterRunnerConfiguration configuration, String importFolderPath, String importSetTitle) throws Exception {
        return new DamMultiThreadedImporter(configuration, importFolderPath, null, importSetTitle, false);
    }

    public static DamMultiThreadedImporter createWithImportFolderPath(ImporterRunnerConfiguration configuration, String importFolderPath, String importSetTitle, boolean removeImportedFolder) throws Exception {
        return new DamMultiThreadedImporter(configuration, importFolderPath, null, importSetTitle, removeImportedFolder);
    }

    public static DamMultiThreadedImporter createWithImportFolderTitle(ImporterRunnerConfiguration configuration, String importFolderTitle, String importSetTitle) throws Exception {
        return new DamMultiThreadedImporter(configuration, null, importFolderTitle, importSetTitle, false);
    }

    public static DamMultiThreadedImporter createWithImportFolderTitle(ImporterRunnerConfiguration configuration, String importFolderTitle, String importSetTitle, boolean removeImportedFolder) throws Exception {
        return new DamMultiThreadedImporter(configuration, null, importFolderTitle, importSetTitle, removeImportedFolder);
    }

    protected DamMultiThreadedImporter(ImporterRunnerConfiguration configuration, String importFolderPath, String importFolderTitle, String importSetTitle, boolean removeImportedFolder) throws Exception {
        super(configuration);
        this.importFolderPath = importFolderPath;
        this.importFolderTitle = importFolderTitle;
        this.importSetTitle = importSetTitle;
        this.removeImportedFolder = removeImportedFolder;
    }

    protected DocumentModel createTargetContainer() throws Exception {
        TargetContainerCreator tcc = new TargetContainerCreator(this.getCoreSession().getRepositoryName(), this.importFolderPath, this.importFolderTitle, this.importSetTitle, this.importWritePath, this.importSource);
        UnrestrictedSessionRunnerHelper.runInNewThread(tcc);
        return this.getCoreSession().getDocument(tcc.targetContainer.getRef());
    }

    protected void doRun() throws Exception {
        super.doRun();
        this.removeImportedFolder();
    }

    protected void removeImportedFolder() {
        if (this.removeImportedFolder && this.importSource instanceof FileSourceNode) {
            FileSourceNode sourceNode = (FileSourceNode)this.importSource;
            FileUtils.deleteTree((File)sourceNode.getFile());
        }
    }
}

