/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.factories;

import java.util.HashMap;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.importer.factories.AbstractDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class DefaultDocumentModelFactory
extends AbstractDocumentModelFactory {
    protected String folderishType;
    protected String leafType;

    public DefaultDocumentModelFactory() {
        this("Folder", "File");
    }

    public DefaultDocumentModelFactory(String folderishType, String leafType) {
        this.folderishType = folderishType;
        this.leafType = leafType;
    }

    @Override
    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        String name = this.getValidNameFromFileName(node.getName());
        HashMap options = new HashMap();
        DocumentModel doc = session.createDocumentModel(this.folderishType, options);
        doc.setPathInfo(parent.getPathAsString(), name);
        doc.setProperty("dublincore", "title", (Object)node.getName());
        doc = session.createDocument(doc);
        return doc;
    }

    @Override
    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        return this.defaultCreateLeafNode(session, parent, node);
    }

    protected DocumentModel defaultCreateLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        BlobHolder bh = node.getBlobHolder();
        String mimeType = bh.getBlob().getMimeType();
        if (mimeType == null) {
            mimeType = this.getMimeType(node.getName());
        }
        String name = this.getValidNameFromFileName(node.getName());
        String fileName = node.getName();
        HashMap options = new HashMap();
        DocumentModel doc = session.createDocumentModel(this.leafType, options);
        doc.setPathInfo(parent.getPathAsString(), name);
        doc.setProperty("dublincore", "title", (Object)node.getName());
        doc.setProperty("file", "filename", (Object)fileName);
        doc.setProperty("file", "content", (Object)bh.getBlob());
        doc = session.createDocument(doc);
        doc = this.setDocumentProperties(session, bh.getProperties(), doc);
        return doc;
    }

    protected String getMimeType(String name) {
        if (name == null) {
            return "application/octet-stream";
        }
        if (name.endsWith(".odp")) {
            return "application/vnd.oasis.opendocument.presentation";
        }
        if (name.endsWith(".otp")) {
            return "application/vnd.oasis.opendocument.presentation-template";
        }
        if (name.endsWith(".otg")) {
            return "application/vnd.oasis.opendocument.graphics-template";
        }
        if (name.endsWith(".odg")) {
            return "application/vnd.oasis.opendocument.graphics";
        }
        if (name.endsWith(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (name.endsWith(".ott")) {
            return "application/vnd.oasis.opendocument.text-template";
        }
        if (name.endsWith(".ods")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        if (name.endsWith(".ots")) {
            return "application/vnd.oasis.opendocument.spreadsheet-template";
        }
        if (name.endsWith(".doc")) {
            return "application/msword";
        }
        if (name.endsWith(".xls")) {
            return "application/vnd.ms-excel";
        }
        if (name.endsWith(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (name.endsWith(".xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (name.endsWith(".pptx")) {
            return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        }
        if (name.endsWith(".docx")) {
            return "application/vnd.openxmlformats-officedocument.wordprocessingml.template";
        }
        if (name.endsWith(".tar")) {
            return "application/x-gtar";
        }
        if (name.endsWith(".gz")) {
            return "application/x-gtar";
        }
        if (name.endsWith(".csv")) {
            return "text/csv";
        }
        if (name.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        if (name.endsWith(".html")) {
            return "text/html";
        }
        if (name.endsWith(".xml")) {
            return "text/xml";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".jpg")) {
            return "image/jpg";
        }
        if (name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".zip")) {
            return "application/zip";
        }
        return "application/octet-stream";
    }

    public void setFolderishType(String folderishType) {
        this.folderishType = folderishType;
    }

    public void setLeafType(String leafType) {
        this.leafType = leafType;
    }
}

