/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.platform.context;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.api.Framework;

class ContainerFolderCreator
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(ContainerFolderCreator.class);
    protected String folderTitle;
    public DocumentModel folder;

    public ContainerFolderCreator(String repositoryName, String folderTitle) {
        super(repositoryName);
        this.folderTitle = folderTitle;
    }

    public void run() throws ClientException {
        try {
            DamService damService = (DamService)Framework.getLocalService(DamService.class);
            this.folder = this.session.createDocumentModel(damService.getAssetLibraryPath(), IdUtils.generateId((String)this.folderTitle), "ImportFolder");
            this.folder.setPropertyValue("dc:title", (Serializable)((Object)this.folderTitle));
            this.folder = this.session.createDocument(this.folder);
            this.session.save();
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

