/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image;

import java.text.DecimalFormat;
import java.util.logging.Logger;

public class ColorMatrix {
    private static final String CLASS = ColorMatrix.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final DecimalFormat FORMAT = new DecimalFormat("+0.0000;-0.0000");
    private static final long SHORT_MASK = 65535L;
    public static final ColorMatrix XYZ_TO_RGB = new ColorMatrix(new double[]{0.412453, 0.35758, 0.180423, 0.212671, 0.71516, 0.072169, 0.019334, 0.119193, 0.950227});
    private final double[] c;

    public ColorMatrix(double[] coefficients) {
        this.c = coefficients;
    }

    public final void process(short[] data, int index) {
        short d0 = this.compute(0, data, index);
        short d1 = this.compute(1, data, index);
        short d2 = this.compute(2, data, index);
        data[index + 0] = d0;
        data[index + 1] = d1;
        data[index + 2] = d2;
    }

    public final ColorMatrix product(ColorMatrix m) {
        double[] r = new double[9];
        r[2] = this.c[0] * m.c[2] + this.c[1] * m.c[5] + this.c[2] * m.c[8];
        r[5] = this.c[3] * m.c[2] + this.c[4] * m.c[5] + this.c[5] * m.c[8];
        r[8] = this.c[6] * m.c[2] + this.c[7] * m.c[5] + this.c[8] * m.c[8];
        r[1] = this.c[0] * m.c[1] + this.c[1] * m.c[4] + this.c[2] * m.c[7];
        r[4] = this.c[3] * m.c[1] + this.c[4] * m.c[4] + this.c[5] * m.c[7];
        r[7] = this.c[6] * m.c[1] + this.c[7] * m.c[4] + this.c[8] * m.c[7];
        r[0] = this.c[0] * m.c[0] + this.c[1] * m.c[3] + this.c[2] * m.c[6];
        r[3] = this.c[3] * m.c[0] + this.c[4] * m.c[3] + this.c[5] * m.c[6];
        r[6] = this.c[6] * m.c[0] + this.c[7] * m.c[3] + this.c[8] * m.c[6];
        return new ColorMatrix(r);
    }

    public final void normalizeRows() {
        double sum = this.c[0] + this.c[1] + this.c[2];
        this.c[0] = this.c[0] / sum;
        this.c[1] = this.c[1] / sum;
        this.c[2] = this.c[2] / sum;
        sum = this.c[3] + this.c[4] + this.c[5];
        this.c[3] = this.c[3] / sum;
        this.c[4] = this.c[4] / sum;
        this.c[5] = this.c[5] / sum;
        sum = this.c[6] + this.c[7] + this.c[8];
        this.c[6] = this.c[6] / sum;
        this.c[7] = this.c[7] / sum;
        this.c[8] = this.c[8] / sum;
    }

    public final ColorMatrix inverse() {
        double cof0 = this.c[4] * this.c[8] - this.c[7] * this.c[5];
        double cof1 = -(this.c[3] * this.c[8] - this.c[6] * this.c[5]);
        double cof2 = this.c[3] * this.c[7] - this.c[6] * this.c[4];
        double cof3 = -(this.c[1] * this.c[8] - this.c[7] * this.c[2]);
        double cof4 = this.c[0] * this.c[8] - this.c[6] * this.c[2];
        double cof5 = -(this.c[0] * this.c[7] - this.c[6] * this.c[1]);
        double cof6 = this.c[1] * this.c[5] - this.c[4] * this.c[2];
        double cof7 = -(this.c[0] * this.c[5] - this.c[3] * this.c[2]);
        double cof8 = this.c[0] * this.c[4] - this.c[3] * this.c[1];
        double det = this.c[0] * cof0 + this.c[1] * cof1 + this.c[2] * cof2;
        double[] nc = new double[]{cof0 / det, cof3 / det, cof6 / det, cof1 / det, cof4 / det, cof7 / det, cof2 / det, cof5 / det, cof8 / det};
        ColorMatrix result = new ColorMatrix(nc);
        logger.finest("inverse(" + this + ") = " + result);
        return result;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < this.c.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(FORMAT.format(this.c[i]));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private short compute(int channel, short[] data, int index) {
        double c0 = this.c[channel * 3 + 0];
        double c1 = this.c[channel * 3 + 1];
        double c2 = this.c[channel * 3 + 2];
        double f = c0 * (double)((long)data[index + 0] & 0xFFFFL) + c1 * (double)((long)data[index + 1] & 0xFFFFL) + c2 * (double)((long)data[index + 2] & 0xFFFFL);
        int x = (int)f;
        if (x < 0) {
            return 0;
        }
        return (short)((long)x <= 65535L ? (long)x : 65535L);
    }
}

