/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.Kernel2;
import it.tidalwave.image.Quality;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Java2DUtils {
    private static final String CLASS = Java2DUtils.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    public static final Float ZERO = new Float(0.0f);
    private static final Map<Quality, Object> renderingHintsQualityMap = Collections.unmodifiableMap(new HashMap<Quality, Object>(){
        {
            this.put(Quality.FASTEST, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.put(Quality.INTERMEDIATE, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.put(Quality.BEST, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
    });
    private static final Map<Quality, Integer> affineTransformQualityMap = Collections.unmodifiableMap(new HashMap<Quality, Integer>(){
        {
            this.put(Quality.FASTEST, 1);
            this.put(Quality.INTERMEDIATE, 2);
            this.put(Quality.BEST, 3);
        }
    });

    public static Properties getProperties(BufferedImage image) {
        Properties properties = new Properties();
        String[] propertyNames = image.getPropertyNames();
        if (propertyNames != null) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                Object propertyValue = image.getProperty(propertyName);
                properties.setProperty(propertyName, propertyValue.toString());
            }
        }
        return properties;
    }

    public static BufferedImage createOptimizedImage(int width, int height) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height);
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice gd = gs[0];
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        return gc;
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int newWidth, int newHeight) {
        SampleModel sampleModel = bufferedImage.getSampleModel().createCompatibleSampleModel(newWidth, newHeight);
        WritableRaster newRaster = Raster.createWritableRaster(sampleModel, null);
        ColorModel colorModel = bufferedImage.getColorModel();
        return new BufferedImage(colorModel, newRaster, false, Java2DUtils.getProperties(bufferedImage));
    }

    public static String getICCProfileName(RenderedImage image) {
        ICC_Profile iccProfile = ImageUtils.getICCProfile(image);
        if (iccProfile != null) {
            return ImageUtils.getICCProfileName(iccProfile);
        }
        return null;
    }

    public static BufferedImage convertToSinglePixelPackedSampleModel(BufferedImage image) {
        logger.fine("convertToSinglePixelPackedSampleModel(image: " + image + ")");
        Java2DUtils.logImage(logger, ">>>> source bufferedImage", image);
        long time = System.currentTimeMillis();
        WritableRaster sourceRaster = image.getRaster();
        PixelInterleavedSampleModel sourceSampleModel = (PixelInterleavedSampleModel)sourceRaster.getSampleModel();
        ColorModel colorModel = image.getColorModel();
        ICC_ColorSpace colorSpace = (ICC_ColorSpace)colorModel.getColorSpace();
        if (colorSpace.getType() == 6) {
            logger.fine(">>>> TYPE_GRAY, not converting");
        } else {
            int[] bitMasks = new int[]{0xFF0000, 65280, 255};
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, image.getWidth(), image.getHeight(), bitMasks);
            WritableRaster destRaster = Raster.createWritableRaster(sampleModel, null);
            DataBufferInt destDataBuffer = (DataBufferInt)destRaster.getDataBuffer();
            int[] destBuffer = destDataBuffer.getData();
            int[] bandOffsets = sourceSampleModel.getBandOffsets();
            int i = 0;
            while (i < bandOffsets.length) {
                int n = i++;
                bandOffsets[n] = bandOffsets[n] + (-sourceRaster.getSampleModelTranslateX() * sourceSampleModel.getPixelStride() - sourceRaster.getSampleModelTranslateY() * sourceSampleModel.getScanlineStride());
            }
            DataBuffer sourceDataBuffer = sourceRaster.getDataBuffer();
            if (sourceDataBuffer instanceof DataBufferUShort) {
                Java2DUtils.convertUShortDataBuffer(image, (DataBufferUShort)sourceDataBuffer, sourceSampleModel, bandOffsets, destBuffer);
            } else if (sourceDataBuffer instanceof DataBufferByte) {
                Java2DUtils.convertByteDataBuffer(image, (DataBufferByte)sourceDataBuffer, sourceSampleModel, bandOffsets, destBuffer);
            } else {
                throw new IllegalArgumentException("Cannot deal with " + sourceDataBuffer.getClass());
            }
            String sourceProfileName = ImageUtils.getICCProfileName(colorSpace.getProfile());
            if (sourceProfileName.equals("Nikon sRGB 4.0.0.3001")) {
                logger.warning(">>>> Workaround #1094403: using sRGB instead of " + sourceProfileName);
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1004));
            }
            colorModel = new DirectColorModel(colorSpace, 24, bitMasks[0], bitMasks[1], bitMasks[2], 0, false, 3);
            image = new BufferedImage(colorModel, destRaster, false, null);
        }
        time = System.currentTimeMillis() - time;
        Java2DUtils.logImage(logger, ">>>> convertToSinglePixelPackedSampleModel() returning", image);
        logger.fine(">>>> convertToSinglePixelPackedSampleModel() completed ok in " + time + " msec");
        return image;
    }

    public static BufferedImage scaleWithAffineTransform(BufferedImage bufferedImage, double xScale, double yScale, Quality quality) throws IllegalArgumentException {
        logger.fine("scaleWithAffineTransform(" + xScale + ", " + yScale + ", " + (Object)((Object)quality));
        AffineTransform transform = AffineTransform.getScaleInstance(xScale, yScale);
        int interpolation = Java2DUtils.findAffineTransformInterpolation(quality);
        logger.finer(">>>> AffineTransformOp(" + transform + ", " + interpolation + ")");
        AffineTransformOp op = new AffineTransformOp(transform, interpolation);
        return op.filter(bufferedImage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage scaleWithDrawImage(BufferedImage bufferedImage, double xScale, double yScale, Quality quality) throws IllegalArgumentException {
        logger.fine("scaleWithDrawImage(" + xScale + ", " + yScale + ", " + (Object)((Object)quality));
        int newWidth = (int)Math.round((double)bufferedImage.getWidth() * xScale);
        int newHeight = (int)Math.round((double)bufferedImage.getHeight() * yScale);
        BufferedImage result = Java2DUtils.createCompatibleImage(bufferedImage, newWidth, newHeight);
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        Object interpolation = Java2DUtils.findRenderingHintsInterpolation(quality);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        try {
            g2d.drawImage(bufferedImage, 0, 0, newWidth, newHeight, null);
        }
        finally {
            g2d.dispose();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage rotateWithDrawImage(BufferedImage bufferedImage, double degrees, Quality quality) {
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int newWidth = (int)Math.round(Math.abs((double)width * cos) + Math.abs((double)height * sin));
        int newHeight = (int)Math.round(Math.abs((double)width * sin) + Math.abs((double)height * cos));
        BufferedImage result = Java2DUtils.createCompatibleImage(bufferedImage, newWidth, newHeight);
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        Object interpolation = Java2DUtils.findRenderingHintsInterpolation(quality);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        try {
            g2d.transform(AffineTransform.getTranslateInstance((newWidth - width) / 2, (newHeight - height) / 2));
            g2d.transform(AffineTransform.getRotateInstance(-radians, width / 2, height / 2));
            g2d.drawImage((Image)bufferedImage, 0, 0, null);
        }
        finally {
            g2d.dispose();
        }
        return result;
    }

    protected static String toString(int[] array, int radix) {
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < array.length; ++i) {
            buffer.append(Integer.toString(array[i], radix));
            if (i >= array.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static void logImage(Logger logger, String prefix, RenderedImage image) {
        if (logger.isLoggable(Level.FINE)) {
            ColorModel colorModel = image.getColorModel();
            logger.fine(prefix + ".size:           " + image.getWidth() + ", " + image.getHeight());
            logger.fine(prefix + ".tiles:          " + image.getNumXTiles() + " " + image.getNumYTiles());
            logger.fine(prefix + ".class:          " + image.getClass().getName());
            logger.fine(prefix + ".sampleModel:    " + Java2DUtils.toString(image.getSampleModel()));
            if (colorModel != null) {
                logger.fine(prefix + ".colorModel:     " + colorModel.getClass().getName() + " : " + colorModel);
                logger.fine(prefix + ".colorSpace:     " + Java2DUtils.toString(colorModel.getColorSpace()));
            }
        }
    }

    private static String toString(SampleModel sampleModel) {
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return Java2DUtils.toString((SinglePixelPackedSampleModel)sampleModel);
        }
        if (sampleModel instanceof PixelInterleavedSampleModel) {
            return Java2DUtils.toString((PixelInterleavedSampleModel)sampleModel);
        }
        return sampleModel.toString();
    }

    private static String toString(ColorSpace colorSpace) {
        if (colorSpace instanceof ICC_ColorSpace) {
            return Java2DUtils.toString((ICC_ColorSpace)colorSpace);
        }
        return colorSpace.toString();
    }

    private static String toString(ICC_ColorSpace colorSpace) {
        StringBuffer buffer = new StringBuffer("");
        buffer.append(colorSpace.getClass().getName());
        buffer.append("[type: ");
        buffer.append(colorSpace.getType());
        buffer.append(", profile name: ");
        buffer.append(ImageUtils.getICCProfileName(colorSpace.getProfile()));
        buffer.append("]");
        return buffer.toString();
    }

    private static String toString(SinglePixelPackedSampleModel sampleModel) {
        StringBuffer buffer = new StringBuffer("");
        buffer.append(sampleModel.getClass().getName());
        buffer.append("[width: ");
        buffer.append(sampleModel.getWidth());
        buffer.append(", height: ");
        buffer.append(sampleModel.getHeight());
        buffer.append(", numBands: ");
        buffer.append(sampleModel.getNumBands());
        buffer.append(", dataType: ");
        buffer.append(sampleModel.getDataType());
        buffer.append(", scanlineStride: ");
        buffer.append(sampleModel.getScanlineStride());
        buffer.append(", transferType: ");
        buffer.append(sampleModel.getTransferType());
        buffer.append(", numDataElements: ");
        buffer.append(sampleModel.getNumDataElements());
        buffer.append(", bitMasks: ");
        buffer.append(Java2DUtils.toString(sampleModel.getBitMasks(), 16));
        buffer.append(", bitOffsets: ");
        buffer.append(Java2DUtils.toString(sampleModel.getBitOffsets(), 10));
        buffer.append("]");
        return buffer.toString();
    }

    private static String toString(PixelInterleavedSampleModel sampleModel) {
        StringBuffer buffer = new StringBuffer("");
        buffer.append(sampleModel.getClass().getName());
        buffer.append("[width: ");
        buffer.append(sampleModel.getWidth());
        buffer.append(", height: ");
        buffer.append(sampleModel.getHeight());
        buffer.append(", numBands: ");
        buffer.append(sampleModel.getNumBands());
        buffer.append(", dataType: ");
        buffer.append(sampleModel.getDataType());
        buffer.append(", scanlineStride: ");
        buffer.append(sampleModel.getScanlineStride());
        buffer.append(", transferType: ");
        buffer.append(sampleModel.getTransferType());
        buffer.append(", numDataElements: ");
        buffer.append(sampleModel.getNumDataElements());
        buffer.append(", bandOffsets: ");
        buffer.append(Java2DUtils.toString(sampleModel.getBandOffsets(), 10));
        buffer.append(", bankIndices: ");
        buffer.append(Java2DUtils.toString(sampleModel.getBankIndices(), 10));
        buffer.append("]");
        return buffer.toString();
    }

    private static void convertUShortDataBuffer(BufferedImage image, DataBufferUShort sourceDataBuffer, PixelInterleavedSampleModel sourceSampleModel, int[] bandOffsets, int[] destBuffer) {
        int base = 0;
        int i = 0;
        short[] sourceBuffer = sourceDataBuffer.getData();
        for (int y = 0; y < image.getHeight(); ++y) {
            int j = base;
            for (int x = 0; x < image.getWidth(); ++x) {
                int r = (sourceBuffer[j + bandOffsets[0]] & 0xFFFF) >> 8;
                int g = (sourceBuffer[j + bandOffsets[1]] & 0xFFFF) >> 8;
                int b = (sourceBuffer[j + bandOffsets[2]] & 0xFFFF) >> 8;
                destBuffer[i++] = r << 16 | g << 8 | b;
                j += 3;
            }
            base += sourceSampleModel.getScanlineStride();
        }
    }

    private static void convertByteDataBuffer(BufferedImage image, DataBufferByte sourceDataBuffer, PixelInterleavedSampleModel sourceSampleModel, int[] bandOffsets, int[] destBuffer) {
        int base = 0;
        int i = 0;
        byte[] sourceBuffer = sourceDataBuffer.getData();
        int pixelStride = sourceSampleModel.getPixelStride();
        for (int y = 0; y < image.getHeight(); ++y) {
            int j = base;
            for (int x = 0; x < image.getWidth(); ++x) {
                int r = sourceBuffer[j + bandOffsets[0]] & 0xFF;
                int g = sourceBuffer[j + bandOffsets[1]] & 0xFF;
                int b = sourceBuffer[j + bandOffsets[2]] & 0xFF;
                destBuffer[i++] = r << 16 | g << 8 | b;
                j += pixelStride;
            }
            base += sourceSampleModel.getScanlineStride();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createOptimizedImage(BufferedImage bufferedImage, double xScale, double yScale, Quality quality) {
        logger.fine("createOptimizedImage(" + xScale + ", " + yScale + ", " + (Object)((Object)quality) + ")");
        int iw = (int)Math.round(xScale * (double)bufferedImage.getWidth());
        int ih = (int)Math.round(yScale * (double)bufferedImage.getHeight());
        BufferedImage image2 = Java2DUtils.createOptimizedImage(iw, ih);
        Graphics2D g = (Graphics2D)image2.getGraphics();
        try {
            Object interpolation = Java2DUtils.findRenderingHintsInterpolation(quality);
            logger.finer(">>>> applying AffineTransform.getScaleInstance() with RenderingHint: " + interpolation);
            Object renderingHintSave = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
            AffineTransform transform = xScale == 1.0 && yScale == 1.0 ? null : AffineTransform.getScaleInstance(xScale, yScale);
            g.drawRenderedImage(bufferedImage, transform);
            if (renderingHintSave != null) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, renderingHintSave);
            }
            logger.finer(">>>>>>>> iccProfile is now: " + Java2DUtils.getICCProfileName(image2));
        }
        finally {
            g.dispose();
        }
        return image2;
    }

    public static Object findRenderingHintsInterpolation(Quality quality) throws IllegalArgumentException {
        if (!renderingHintsQualityMap.containsKey((Object)quality)) {
            throw new IllegalArgumentException(quality.toString());
        }
        return renderingHintsQualityMap.get((Object)quality);
    }

    public static int findAffineTransformInterpolation(Quality quality) throws IllegalArgumentException {
        if (!affineTransformQualityMap.containsKey((Object)quality)) {
            throw new IllegalArgumentException(quality.toString());
        }
        return affineTransformQualityMap.get((Object)quality);
    }

    public static Kernel getAveragingKernel(int n) {
        Kernel kernel = null;
        kernel = (n & 1) == 1 ? Java2DUtils.getOddAveragingKernel(n) : Java2DUtils.getEvenAveragingKernel(n);
        return kernel;
    }

    private static Kernel getEvenAveragingKernel(int n) {
        int i;
        int r = n + 1;
        int totalCount = r * r;
        int coreCount = (r - 2) * (r - 2);
        int extCount = totalCount - coreCount;
        float a = 1.0f / (float)(coreCount * 2 + extCount);
        float coreValue = a * 2.0f;
        float extValue = a;
        float[] result = new float[totalCount];
        int j = 0;
        for (i = 0; i < r; ++i) {
            result[j++] = extValue;
        }
        for (int k = 0; k < r - 2; ++k) {
            result[j++] = extValue;
            for (int h = 0; h < r - 2; ++h) {
                result[j++] = coreValue;
            }
            result[j++] = extValue;
        }
        for (i = 0; i < r; ++i) {
            result[j++] = extValue;
        }
        assert (j == totalCount);
        return new Kernel2(r, r, result);
    }

    private static Kernel getOddAveragingKernel(int n) {
        int totalCount = n * n;
        float v = 1.0f / (float)totalCount;
        float[] result = new float[totalCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = v;
        }
        return new Kernel2(n, n, result);
    }
}

