/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.AbstractTokenStream;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenType;
import com.google.caja.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HtmlInputSplitter
extends AbstractTokenStream<HtmlTokenType> {
    private boolean asXml = false;
    private final CharProducer p;
    private boolean inTag;
    private boolean inEscapeExemptBlock;
    private String escapeExemptTagName = null;
    private HtmlTextEscapingMode textEscapingMode;
    private String lastNonIgnorable = null;

    public HtmlInputSplitter(CharProducer p) {
        this.p = p;
    }

    public boolean getTreatedAsXml() {
        return this.asXml;
    }

    public void setTreatedAsXml(boolean asXml) {
        this.asXml = asXml;
    }

    @Override
    protected Token<HtmlTokenType> produce() {
        Token<HtmlTokenType> token = this.parseToken();
        if (null == token) {
            return null;
        }
        if (this.inEscapeExemptBlock) {
            if (token.type != HtmlTokenType.SERVERCODE) {
                token = HtmlInputSplitter.reclassify(token, this.textEscapingMode == HtmlTextEscapingMode.RCDATA ? HtmlTokenType.TEXT : HtmlTokenType.UNESCAPED);
            }
        } else if (!this.asXml) {
            switch ((HtmlTokenType)token.type) {
                case TAGBEGIN: {
                    String canonTagName = this.name(token.text.substring(1));
                    if (!HtmlTextEscapingMode.isTagFollowedByLiteralContent(canonTagName)) break;
                    this.escapeExemptTagName = canonTagName;
                    this.textEscapingMode = HtmlTextEscapingMode.getModeForTag(canonTagName);
                    break;
                }
                case TAGEND: {
                    this.inEscapeExemptBlock = null != this.escapeExemptTagName;
                    break;
                }
            }
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private Token<HtmlTokenType> parseToken() {
        block92: {
            block94: {
                block95: {
                    block93: {
                        start = this.p.getOffset();
                        if (start == (limit = this.p.getLimit())) {
                            return null;
                        }
                        buffer = this.p.getBuffer();
                        ch = buffer[start];
                        if (!this.inTag) break block93;
                        if ('>' == ch) {
                            type = HtmlTokenType.TAGEND;
                            this.inTag = false;
                        } else if ('/' == ch) {
                            if (end != limit && '>' == buffer[end]) {
                                type = HtmlTokenType.TAGEND;
                                this.inTag = false;
                                ++end;
                            } else {
                                type = HtmlTokenType.TEXT;
                            }
                        } else if ('=' == ch) {
                            type = HtmlTokenType.TEXT;
                        } else if ('\"' == ch || '\'' == ch) {
                            type = HtmlTokenType.QSTRING;
                            delim = ch;
                            for (end = start + 1; end < limit; ++end) {
                                if (buffer[end] != delim) continue;
                                ++end;
                                break block92;
                            }
                        } else if (!Character.isWhitespace(ch)) {
                            type = HtmlTokenType.TEXT;
                            while (end < limit) {
                                ch = buffer[end];
                                if (!"=".equals(this.lastNonIgnorable) && '/' == ch && end + 1 < limit && '>' == buffer[end + 1] || '>' == ch || '=' == ch || Character.isWhitespace(ch)) break block92;
                                if (('\"' == ch || '\'' == ch) && end + 1 < limit && ((ch2 = buffer[end + 1]) >= '\u0000' && Character.isWhitespace(ch2) || ch2 == '>' || ch2 == '/')) {
                                    ++end;
                                    break block92;
                                }
                                ++end;
                            }
                        } else {
                            type = HtmlTokenType.IGNORABLE;
                            while (end < limit && Character.isWhitespace(buffer[end])) {
                                ++end;
                            }
                        }
                        break block92;
                    }
                    if (ch != '<') break block94;
                    if (end != limit) break block95;
                    type = HtmlTokenType.TEXT;
                    break block92;
                }
                ch = buffer[end];
                type = null;
                state = null;
                switch (ch) {
                    case '/': {
                        state = State.SLASH;
                        ++end;
                        break;
                    }
                    case '!': {
                        if (!this.inEscapeExemptBlock) {
                            state = State.BANG;
                        } else if (HtmlTextEscapingMode.allowsEscapingTextSpan(this.escapeExemptTagName)) {
                            state = State.UNESCAPED_LT_BANG;
                        }
                        ++end;
                        break;
                    }
                    case '?': {
                        if (!this.inEscapeExemptBlock) {
                            state = State.APP_DIRECTIVE;
                        }
                        ++end;
                        break;
                    }
                    case '%': {
                        state = State.SERVER_CODE;
                        ++end;
                        break;
                    }
                    default: {
                        if (this.isIdentStart(ch) && !this.inEscapeExemptBlock) {
                            state = State.TAGNAME;
                            ++end;
                            break;
                        }
                        if ('<' == ch) {
                            type = HtmlTokenType.TEXT;
                            break;
                        }
                        ++end;
                    }
                }
                if (null == state) break block92;
                block40: while (end < limit) {
                    ch = buffer[end];
                    switch (1.$SwitchMap$com$google$caja$lexer$HtmlInputSplitter$State[state.ordinal()]) {
                        case 1: {
                            if (Character.isWhitespace(ch) || '>' == ch || '/' == ch || '<' == ch) {
                                if (this.inEscapeExemptBlock && '/' == buffer[start + 1] && this.textEscapingMode != HtmlTextEscapingMode.PLAIN_TEXT && this.name(start + 2, end).equals(this.escapeExemptTagName)) {
                                    this.inEscapeExemptBlock = false;
                                    this.escapeExemptTagName = null;
                                    this.textEscapingMode = null;
                                }
                                type = HtmlTokenType.TAGBEGIN;
                                this.inTag = this.inEscapeExemptBlock == false;
                                state = State.DONE;
                                break block40;
                            }
                            ** GOTO lbl205
                        }
                        case 2: {
                            if (!Character.isLetter(ch)) ** GOTO lbl105
                            state = State.TAGNAME;
                            ** GOTO lbl205
lbl105:
                            // 1 sources

                            if ('<' == ch) {
                                type = HtmlTokenType.TEXT;
                                break block40;
                            }
                            ++end;
                            break block40;
                        }
                        case 3: {
                            state = '[' == ch && this.asXml ? State.CDATA : ('-' == ch ? State.BANG_DASH : State.DIRECTIVE);
                            ** GOTO lbl205
                        }
                        case 4: {
                            if (']' == ch) {
                                state = State.CDATA_SQ_1;
                            }
                            ** GOTO lbl205
                        }
                        case 5: {
                            state = ']' == ch ? State.CDATA_SQ_2 : State.CDATA;
                            ** GOTO lbl205
                        }
                        case 6: {
                            if ('>' == ch) {
                                type = HtmlTokenType.CDATA;
                                state = State.DONE;
                            } else if (']' != ch) {
                                state = State.CDATA;
                            }
                            ** GOTO lbl205
                        }
                        case 7: {
                            state = '-' == ch ? State.COMMENT : State.DIRECTIVE;
                            ** GOTO lbl205
                        }
                        case 8: {
                            if ('-' == ch) {
                                state = State.COMMENT_DASH;
                            }
                            ** GOTO lbl205
                        }
                        case 9: {
                            state = '-' == ch ? State.COMMENT_DASH_DASH : State.COMMENT_DASH;
                            ** GOTO lbl205
                        }
                        case 10: {
                            if ('>' == ch) {
                                state = State.DONE;
                                type = HtmlTokenType.COMMENT;
                            } else {
                                state = '-' == ch ? State.COMMENT_DASH_DASH : State.COMMENT_DASH;
                            }
                            ** GOTO lbl205
                        }
                        case 11: {
                            if ('>' == ch) {
                                type = HtmlTokenType.DIRECTIVE;
                                state = State.DONE;
                            }
                            ** GOTO lbl205
                        }
                        case 12: {
                            if ('?' == ch) {
                                state = State.APP_DIRECTIVE_QMARK;
                            }
                            ** GOTO lbl205
                        }
                        case 13: {
                            if ('>' == ch) {
                                type = HtmlTokenType.DIRECTIVE;
                                state = State.DONE;
                            } else if ('?' != ch) {
                                state = State.APP_DIRECTIVE;
                            }
                            ** GOTO lbl205
                        }
                        case 14: {
                            if ('%' == ch) {
                                state = State.SERVER_CODE_PCT;
                            }
                            ** GOTO lbl205
                        }
                        case 15: {
                            if ('>' == ch) {
                                type = HtmlTokenType.SERVERCODE;
                                state = State.DONE;
                            } else if ('%' != ch) {
                                state = State.SERVER_CODE;
                            }
                            ** GOTO lbl205
                        }
                        case 16: {
                            if ('-' == ch) {
                                state = State.UNESCAPED_LT_BANG_DASH;
                            } else {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            }
                            ** GOTO lbl205
                        }
                        case 17: {
                            if ('-' == ch) {
                                state = State.ESCAPING_TEXT_SPAN_DASH_DASH;
                            } else {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            }
                            ** GOTO lbl205
                        }
                        case 18: {
                            if ('-' == ch) {
                                state = State.ESCAPING_TEXT_SPAN_DASH;
                            }
                            ** GOTO lbl205
                        }
                        case 19: {
                            state = '-' == ch ? State.ESCAPING_TEXT_SPAN_DASH_DASH : State.ESCAPING_TEXT_SPAN;
                            ** GOTO lbl205
                        }
                        case 20: {
                            if ('>' == ch) {
                                type = HtmlTokenType.TEXT;
                                state = State.DONE;
                            } else if ('-' != ch) {
                                state = State.ESCAPING_TEXT_SPAN;
                            }
                            ** GOTO lbl205
                        }
                        case 21: {
                            throw new AssertionError();
                        }
lbl205:
                        // 28 sources

                        default: {
                            ++end;
                            if (State.DONE != state) continue block40;
                            break block40;
                        }
                    }
                }
                if (end == limit) {
                    switch (1.$SwitchMap$com$google$caja$lexer$HtmlInputSplitter$State[state.ordinal()]) {
                        case 21: {
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            type = HtmlTokenType.CDATA;
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            type = HtmlTokenType.COMMENT;
                            break;
                        }
                        case 11: 
                        case 12: 
                        case 13: {
                            type = HtmlTokenType.DIRECTIVE;
                            break;
                        }
                        case 14: 
                        case 15: {
                            type = HtmlTokenType.SERVERCODE;
                            break;
                        }
                        case 1: {
                            type = HtmlTokenType.TAGBEGIN;
                            break;
                        }
                        default: {
                            type = HtmlTokenType.TEXT;
                        }
                    }
                }
                break block92;
            }
            type = null;
        }
        if (null == type) {
            while (end < limit && '<' != buffer[end]) {
                ++end;
            }
            type = HtmlTokenType.TEXT;
        }
        this.p.consumeTo(end);
        text = this.p.toString(start, end);
        if (type != HtmlTokenType.IGNORABLE) {
            this.lastNonIgnorable = text;
        }
        return Token.instance(text, type, this.p.filePositionForOffsets(start, end));
    }

    protected String name(String tagName) {
        return this.asXml || tagName.indexOf(58) >= 0 ? tagName : Strings.toLowerCase(tagName);
    }

    private String name(int start, int end) {
        return this.name(this.p.toString(start, end));
    }

    private boolean isIdentStart(char ch) {
        if (ch >= 'A' && ch <= 'z' && (ch <= 'Z' || ch >= 'a')) {
            return true;
        }
        if (!this.asXml) {
            return false;
        }
        if (ch < '\u0080') {
            return ch == ':' || ch == '_';
        }
        return ch >= '\u00c0' && ch <= '\u00d6' || ch >= '\u00f7' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufefc' || ch >= '\uff66' && ch <= '\uff9d' || ch >= '\uffa0' && ch <= '\uffdc';
    }

    static <T extends TokenType> Token<T> reclassify(Token<T> token, T type) {
        return Token.instance(token.text, type, token.pos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        TAGNAME,
        SLASH,
        BANG,
        CDATA,
        CDATA_SQ_1,
        CDATA_SQ_2,
        BANG_DASH,
        COMMENT,
        COMMENT_DASH,
        COMMENT_DASH_DASH,
        DIRECTIVE,
        DONE,
        APP_DIRECTIVE,
        APP_DIRECTIVE_QMARK,
        SERVER_CODE,
        SERVER_CODE_PCT,
        UNESCAPED_LT_BANG,
        UNESCAPED_LT_BANG_DASH,
        ESCAPING_TEXT_SPAN,
        ESCAPING_TEXT_SPAN_DASH,
        ESCAPING_TEXT_SPAN_DASH_DASH;

    }
}

