/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Pair;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Conditional
extends AbstractStatement {
    @ParseTreeNode.ReflectiveCtor
    public Conditional(FilePosition pos, Void value, List<? extends ParseTreeNode> children) {
        super(pos, ParseTreeNode.class);
        this.createMutation().appendChildren(children).execute();
    }

    public Conditional(FilePosition pos, List<Pair<Expression, Statement>> ifClauses, Statement elseClause) {
        super(pos, ParseTreeNode.class);
        if (ifClauses.isEmpty()) {
            throw new IllegalArgumentException();
        }
        MutableParseTreeNode.Mutation m = this.createMutation();
        for (Pair<Expression, Statement> p : ifClauses) {
            Expression condition = (Expression)p.a;
            Statement then = (Statement)p.b;
            if (null == condition || null == then) {
                throw new IllegalArgumentException();
            }
            m.appendChild(condition);
            m.appendChild(then);
        }
        if (null != elseClause) {
            m.appendChild(elseClause);
        }
        m.execute();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        List<? extends ParseTreeNode> children = this.children();
        int i = 0;
        int n = children.size();
        while (i + 2 <= n) {
            Expression condition = (Expression)children.get(i);
            Statement body = (Statement)children.get(i + 1);
            if (i != 0) {
                out.consume("else");
            }
            out.consume("if");
            out.consume("(");
            condition.render(rc);
            out.consume(")");
            boolean hanging = body.hasHangingConditional();
            if (hanging) {
                out.consume("{");
            }
            body.renderBlock(rc, i + 2 < n);
            if (hanging) {
                out.consume("}");
            }
            i += 2;
        }
        if (i < n) {
            Statement body = (Statement)children.get(i);
            out.consume("else");
            body.renderBlock(rc, false);
        }
    }

    @Override
    public boolean hasHangingConditional() {
        List<? extends ParseTreeNode> children = this.children();
        int n = children.size();
        if ((n & 1) == 0) {
            return true;
        }
        return ((Statement)children.get(n - 1)).hasHangingConditional();
    }
}

