/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.CajoledModuleExpression;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import java.util.ArrayList;
import java.util.Map;

@RulesetDescription(name="Caja Transformation Rules", synopsis="Top-level module envelop")
public class CajitaModuleRewriter
extends Rewriter {
    private final BuildInfo buildInfo;
    private final PluginEnvironment pluginEnv;
    private final boolean isFromValija;
    public final Rule[] cajaRules = new Rule[]{new Rule(){

        @RuleDescription(name="topLevelModule", synopsis="produce a module map and add a wrapper;only apply to top level module", reason="", matches="<an UncajoledModule>", substitutes="      ({      instantiate: function (___, IMPORTS___) {        var moduleResult___ = ___.NO_RESULT;        var moduleMap___ = {};        @setModules*;        moduleResult___ =          moduleMap___[0](IMPORTS___);        return moduleResult___;      },      cajolerName: @cajolerName,      cajolerVersion: @cajolerVersion,      cajoledDate: @cajoledDate    })")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof UncajoledModule) {
                ModuleManager moduleManager = new ModuleManager(CajitaModuleRewriter.this.buildInfo, CajitaModuleRewriter.this.pluginEnv, CajitaModuleRewriter.this.mq, CajitaModuleRewriter.this.isFromValija);
                moduleManager.appendUncajoledModule((UncajoledModule)node);
                ArrayList<ExpressionStmt> moduleDefs = new ArrayList<ExpressionStmt>();
                Map<Integer, CajoledModule> modules = moduleManager.getModuleIndexMap();
                if (modules.size() == 1) {
                    return modules.get(0);
                }
                for (int k : modules.keySet()) {
                    ParseTreeNode e = QuasiBuilder.substV("moduleMap___[@moduleIndex] = @cajoledModuleExpression;", "moduleIndex", new IntegerLiteral(FilePosition.UNKNOWN, k), "cajoledModuleExpression", new CajoledModuleExpression(FilePosition.UNKNOWN, modules.get(k)));
                    moduleDefs.add(new ExpressionStmt((Expression)e));
                }
                ObjectConstructor moduleObjectLiteral = (ObjectConstructor)this.substV("setModules", new ParseTreeNodeContainer(moduleDefs), "cajolerName", new StringLiteral(FilePosition.UNKNOWN, "com.google.caja"), "cajolerVersion", new StringLiteral(FilePosition.UNKNOWN, CajitaModuleRewriter.this.buildInfo.getBuildVersion()), "cajoledDate", new IntegerLiteral(FilePosition.UNKNOWN, CajitaModuleRewriter.this.buildInfo.getCurrentTime()));
                return new CajoledModule(moduleObjectLiteral);
            }
            return NONE;
        }
    }};

    public CajitaModuleRewriter(BuildInfo buildInfo, PluginEnvironment pluginEnv, MessageQueue mq, boolean logging, boolean isFromValija) {
        super(mq, false, logging);
        this.buildInfo = buildInfo;
        this.pluginEnv = pluginEnv;
        this.isFromValija = isFromValija;
        this.addRules(this.cajaRules);
    }

    public CajitaModuleRewriter(BuildInfo buildInfo, MessageQueue mq, boolean logging, boolean isFromValija) {
        this(buildInfo, PluginEnvironment.CLOSED_PLUGIN_ENVIRONMENT, mq, logging, isFromValija);
    }
}

