/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import nu.validator.htmlparser.impl.ByteReadable;
import nu.validator.htmlparser.impl.Encoding;

class IcuDetectorSniffer
extends InputStream {
    private final ByteReadable source;

    public IcuDetectorSniffer(ByteReadable source) {
        this.source = source;
    }

    public int read() throws IOException {
        return this.source.readByte();
    }

    Encoding sniff() throws IOException {
        try {
            CharsetDetector detector = new CharsetDetector();
            detector.setText((InputStream)this);
            CharsetMatch match = detector.detect();
            Encoding enc = Encoding.forName(match.getName());
            Encoding actual = enc.getActualHtmlEncoding();
            if (actual != null) {
                enc = actual;
            }
            if (enc != Encoding.WINDOWS1252 && enc.isAsciiSuperset()) {
                return enc;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String[] detectable = CharsetDetector.getAllDetectableCharsets();
        for (int i = 0; i < detectable.length; ++i) {
            String charset = detectable[i];
            System.out.println(charset);
        }
    }
}

