/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.ImageModel;
import it.tidalwave.image.op.ImplementationFactory;
import it.tidalwave.image.op.Operation;
import it.tidalwave.image.op.OperationImplementation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ImplementationFactoryRegistry {
    private static final String CLASS = ImplementationFactoryRegistry.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static ImplementationFactoryRegistry instance;
    private List<ImplementationFactory> factoryList = new ArrayList<ImplementationFactory>();

    private ImplementationFactoryRegistry() {
    }

    public static ImplementationFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new ImplementationFactoryRegistry();
        }
        return instance;
    }

    public void registerFactory(ImplementationFactory factory) {
        this.factoryList.add(factory);
    }

    public ImageModel createImageModel(Object image) {
        for (ImplementationFactory factory : this.factoryList) {
            if (!factory.canConvertFrom(image.getClass())) continue;
            return factory.convertFrom(image);
        }
        throw new IllegalArgumentException("" + image.getClass());
    }

    public OperationImplementation findImplementation(Operation operation, ImageModel imageModel, boolean canConvert) {
        logger.finer("findImplementation(" + operation + ", " + imageModel + " , canConvert: " + canConvert + ")");
        Object image = imageModel != null ? imageModel.getImage() : null;
        for (ImplementationFactory factory : this.factoryList) {
            OperationImplementation implementation = factory.findImplementation(operation);
            if (implementation == null) continue;
            logger.finest(">>>> found implementation from " + factory);
            if (image == null) {
                return implementation;
            }
            logger.finest(">>>> image class: " + image.getClass() + ", factory model class: " + factory.getModelClass());
            if (factory.getModelClass().isAssignableFrom(image.getClass())) {
                return implementation;
            }
            if (canConvert && (factory.canConvertFrom(image.getClass()) || imageModel.getFactory().canConvertTo(factory.getModelClass()))) {
                return implementation;
            }
            logger.finest(">>>> but has been discarded");
        }
        throw new UnsupportedOperationException("Not implemented " + operation + ", imageModel: " + imageModel + " factoryList: " + this.factoryList);
    }
}

