/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.IncorrectCredentialsException;
import org.jsecurity.authc.LogoutAware;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.authc.credential.AllowAllCredentialsMatcher;
import org.jsecurity.authc.credential.CredentialsMatcher;
import org.jsecurity.authc.credential.SimpleCredentialsMatcher;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.realm.CachingRealm;
import org.jsecurity.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatingRealm
extends CachingRealm
implements LogoutAware {
    private static final Log log = LogFactory.getLog(AuthenticatingRealm.class);
    private CredentialsMatcher credentialsMatcher = new SimpleCredentialsMatcher();
    private Class<? extends AuthenticationToken> authenticationTokenClass = UsernamePasswordToken.class;

    public AuthenticatingRealm() {
    }

    public AuthenticatingRealm(CacheManager cacheManager) {
        this.setCacheManager(cacheManager);
    }

    public AuthenticatingRealm(CredentialsMatcher matcher) {
        this.setCredentialsMatcher(matcher);
    }

    public AuthenticatingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        this.setCacheManager(cacheManager);
        this.setCredentialsMatcher(matcher);
    }

    public CredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    public void setCredentialsMatcher(CredentialsMatcher credentialsMatcher) {
        this.credentialsMatcher = credentialsMatcher;
    }

    public Class getAuthenticationTokenClass() {
        return this.authenticationTokenClass;
    }

    public void setAuthenticationTokenClass(Class<? extends AuthenticationToken> authenticationTokenClass) {
        this.authenticationTokenClass = authenticationTokenClass;
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token != null && this.getAuthenticationTokenClass().isAssignableFrom(token.getClass());
    }

    @Override
    public final AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info = this.doGetAuthenticationInfo(token);
        if (info == null) {
            if (log.isDebugEnabled()) {
                String msg = "No authentication information found for submitted authentication token [" + token + "].  " + "Returning null.";
                log.debug((Object)msg);
            }
            return null;
        }
        CredentialsMatcher cm = this.getCredentialsMatcher();
        if (cm != null) {
            if (!cm.doCredentialsMatch(token, info)) {
                String msg = "The credentials provided for account [" + token + "] did not match the expected credentials.";
                throw new IncorrectCredentialsException(msg);
            }
        } else {
            throw new AuthenticationException("A CredentialsMatcher must be configured in order to verify credentials during authentication.  If you do not wish for credentials to be examined, you can configure an " + AllowAllCredentialsMatcher.class.getName() + " instance.");
        }
        return info;
    }

    protected abstract AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken var1) throws AuthenticationException;

    @Override
    public void onLogout(PrincipalCollection principals) {
    }
}

