/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSession
implements Session {
    private Serializable id = null;
    private Date startTimestamp = null;
    private InetAddress hostAddress = null;
    private SessionManager sessionManager = null;

    public DelegatingSession() {
    }

    public DelegatingSession(SessionManager sessionManager, Serializable id) {
        this.sessionManager = sessionManager;
        this.id = id;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public Date getStartTimestamp() {
        if (this.startTimestamp == null) {
            this.startTimestamp = this.sessionManager.getStartTimestamp(this.id);
        }
        return this.startTimestamp;
    }

    @Override
    public Date getLastAccessTime() {
        return this.sessionManager.getLastAccessTime(this.id);
    }

    @Override
    public long getTimeout() throws InvalidSessionException {
        return this.sessionManager.getTimeout(this.id);
    }

    @Override
    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        this.sessionManager.setTimeout(this.id, maxIdleTimeInMillis);
    }

    @Override
    public InetAddress getHostAddress() {
        if (this.hostAddress == null) {
            this.hostAddress = this.sessionManager.getHostAddress(this.id);
        }
        return this.hostAddress;
    }

    @Override
    public void touch() throws InvalidSessionException {
        this.sessionManager.touch(this.id);
    }

    @Override
    public void stop() throws InvalidSessionException {
        this.sessionManager.stop(this.id);
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        return this.sessionManager.getAttributeKeys(this.id);
    }

    @Override
    public Object getAttribute(Object key) throws InvalidSessionException {
        return this.sessionManager.getAttribute(this.id, key);
    }

    @Override
    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        if (value == null) {
            this.removeAttribute(key);
        } else {
            this.sessionManager.setAttribute(this.id, key, value);
        }
    }

    @Override
    public Object removeAttribute(Object key) throws InvalidSessionException {
        return this.sessionManager.removeAttribute(this.id, key);
    }
}

