/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.subject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.RememberMeAuthenticationToken;
import org.jsecurity.codec.Base64;
import org.jsecurity.codec.Hex;
import org.jsecurity.crypto.BlowfishCipher;
import org.jsecurity.crypto.Cipher;
import org.jsecurity.io.DefaultSerializer;
import org.jsecurity.io.SerializationException;
import org.jsecurity.io.Serializer;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.subject.RememberMeManager;

public abstract class AbstractRememberMeManager
implements RememberMeManager {
    private static final Log log = LogFactory.getLog(AbstractRememberMeManager.class);
    private Serializer serializer = new DefaultSerializer();
    private Cipher cipher = new BlowfishCipher();
    private byte[] encryptionCipherKey = null;
    private byte[] decryptionCipherKey = null;

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public byte[] getEncryptionCipherKey() {
        return this.encryptionCipherKey;
    }

    public void setEncryptionCipherKey(byte[] encryptionCipherKey) {
        this.encryptionCipherKey = encryptionCipherKey;
    }

    public void setEncryptionCipherKeyHex(String hex) {
        this.setEncryptionCipherKey(Hex.decode(hex));
    }

    public void setEncryptionCipherKeyBase64(String base64) {
        this.setEncryptionCipherKey(Base64.decode(base64));
    }

    public byte[] getDecryptionCipherKey() {
        return this.decryptionCipherKey;
    }

    public void setDecryptionCipherKey(byte[] decryptionCipherKey) {
        this.decryptionCipherKey = decryptionCipherKey;
    }

    public void setDecryptionCipherKeyHex(String hex) {
        this.setDecryptionCipherKey(Hex.decode(hex));
    }

    public void setDecryptionCipherKeyBase64(String base64) {
        this.setDecryptionCipherKey(Base64.decode(base64));
    }

    public byte[] getCipherKey() {
        return this.getEncryptionCipherKey();
    }

    public void setCipherKey(byte[] cipherKey) {
        this.setEncryptionCipherKey(cipherKey);
        this.setDecryptionCipherKey(cipherKey);
    }

    public void setCipherKeyHex(String hex) {
        this.setCipherKey(Hex.decode(hex));
    }

    public void setCipherKeyBase64(String base64) {
        this.setCipherKey(Base64.decode(base64));
    }

    protected abstract void rememberSerializedIdentity(byte[] var1);

    protected abstract byte[] getSerializedRememberedIdentity();

    protected abstract void forgetIdentity();

    protected boolean isRememberMe(AuthenticationToken token) {
        return token != null && token instanceof RememberMeAuthenticationToken && ((RememberMeAuthenticationToken)token).isRememberMe();
    }

    public void onSuccessfulLogin(AuthenticationToken token, AuthenticationInfo info) {
        this.forgetIdentity(token);
        if (this.isRememberMe(token)) {
            this.rememberIdentity(token, info);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"AuthenticationToken did not indicate RememberMe is requested.  RememberMe functionality will not be executed for corresponding account.");
        }
    }

    public void rememberIdentity(AuthenticationToken submittedToken, AuthenticationInfo successfullyAuthenticated) {
        this.rememberIdentity(successfullyAuthenticated);
    }

    public void rememberIdentity(AuthenticationInfo successfullyAuthenticated) {
        PrincipalCollection principals = this.getIdentityToRemember(successfullyAuthenticated);
        this.rememberIdentity(principals);
    }

    protected PrincipalCollection getIdentityToRemember(AuthenticationInfo info) {
        return info.getPrincipals();
    }

    protected void rememberIdentity(PrincipalCollection accountPrincipals) {
        block3: {
            try {
                byte[] bytes = this.serialize(accountPrincipals);
                if (this.getCipher() != null) {
                    bytes = this.encrypt(bytes);
                }
                this.rememberSerializedIdentity(bytes);
            }
            catch (SerializationException se) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)("Unable to serialize account principals [" + accountPrincipals + "].  Identity " + "cannot be remembered!  This is a non fatal exception as RememberMe identity services " + "are not considered critical and execution can continue as normal.  But please " + "investigate and resolve to prevent seeing this message again."), (Throwable)se);
            }
        }
    }

    public PrincipalCollection getRememberedPrincipals() {
        try {
            PrincipalCollection principals;
            block6: {
                principals = null;
                byte[] bytes = this.getSerializedRememberedIdentity();
                if (bytes != null) {
                    if (this.getCipher() != null) {
                        bytes = this.decrypt(bytes);
                    }
                    try {
                        principals = this.deserialize(bytes);
                    }
                    catch (SerializationException e) {
                        if (!log.isWarnEnabled()) break block6;
                        log.warn((Object)"Unable to deserialize stored identity byte array.  Remembered identity cannot be reconstituted!  This is a non fatal exception as RememberMe identity services are not considered critical and execution can continue as normal, but please investigate and resolve to prevent seeing this message again.", (Throwable)e);
                    }
                }
            }
            return principals;
        }
        catch (Exception e) {
            return this.onRememberedPrincipalFailure(e);
        }
    }

    protected PrincipalCollection onRememberedPrincipalFailure(Exception e) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"There was a failure while trying to retrieve remembered principals.  This could be due to a configuration problem or corrupted principals.  This could also be due to a recently changed encryption key.  The remembered identity will be forgotten and not used for this request.", (Throwable)e);
        }
        this.forgetIdentity();
        return null;
    }

    protected byte[] encrypt(byte[] serialized) {
        byte[] value = serialized;
        Cipher cipher = this.getCipher();
        if (cipher != null) {
            value = cipher.encrypt(serialized, this.getEncryptionCipherKey());
        }
        return value;
    }

    protected byte[] decrypt(byte[] encrypted) {
        byte[] serialized = encrypted;
        Cipher cipher = this.getCipher();
        if (cipher != null) {
            serialized = cipher.decrypt(encrypted, this.getDecryptionCipherKey());
        }
        return serialized;
    }

    protected byte[] serialize(PrincipalCollection principals) {
        return this.getSerializer().serialize(principals);
    }

    protected PrincipalCollection deserialize(byte[] serializedIdentity) {
        return (PrincipalCollection)this.getSerializer().deserialize(serializedIdentity);
    }

    public void onFailedLogin(AuthenticationToken token, AuthenticationException ae) {
        this.forgetIdentity(token, ae);
    }

    public void onLogout(PrincipalCollection subjectPrincipals) {
        this.forgetIdentity();
    }

    protected void forgetIdentity(AuthenticationToken token, AuthenticationException ae) {
        this.forgetIdentity(token);
    }

    protected void forgetIdentity(AuthenticationToken token) {
        this.forgetIdentity();
    }
}

