/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.work.AbstractWork;

public class PictureViewsGenerationWork
extends AbstractWork {
    protected final String repositoryName;
    protected final DocumentRef docRef;
    public static final String CATEGORY_PICTURE_GENERATION = "pictureViewsGeneration";

    public String getCategory() {
        return CATEGORY_PICTURE_GENERATION;
    }

    public String getTitle() {
        return "Picture views generation " + this.docRef;
    }

    public PictureViewsGenerationWork(String repositoryName, DocumentRef docRef) {
        this.repositoryName = repositoryName;
        this.docRef = docRef;
    }

    public void work() throws Exception {
        this.initSession(this.repositoryName);
        DocumentModel doc = this.session.getDocument(this.docRef);
        Property fileProp = doc.getProperty("file:content");
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        bh.setBlob((Blob)fileProp.getValue(Blob.class));
        this.session.saveDocument(doc);
        this.session.save();
    }
}

