/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.testing.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockLowLevelHttpRequest
extends LowLevelHttpRequest {
    private String url;
    private HttpContent content;
    private final Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();

    public MockLowLevelHttpRequest() {
    }

    public MockLowLevelHttpRequest(String url) {
        this.url = url;
    }

    @Override
    public void addHeader(String name, String value) throws IOException {
        List<String> values = this.headersMap.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headersMap.put(name, values);
        }
        values.add(value);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        return this.response;
    }

    @Override
    public void setContent(HttpContent content) throws IOException {
        this.content = content;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headersMap;
    }

    public MockLowLevelHttpRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public String getContentAsString() throws IOException {
        String contentType;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getContent().writeTo(out);
        String contentEncoding = this.content.getEncoding();
        if (contentEncoding != null && contentEncoding.contains("gzip")) {
            GZIPInputStream contentInputStream = new GZIPInputStream(new ByteArrayInputStream(out.toByteArray()));
            out = new ByteArrayOutputStream();
            AbstractInputStreamContent.copy(contentInputStream, out);
        }
        HttpMediaType mediaType = (contentType = this.content.getType()) != null ? new HttpMediaType(contentType) : null;
        Charset charset = mediaType == null || mediaType.getCharsetParameter() == null ? Charsets.ISO_8859_1 : mediaType.getCharsetParameter();
        return out.toString(charset.name());
    }

    public MockLowLevelHttpResponse getResponse() {
        return this.response;
    }

    public MockLowLevelHttpRequest setResponse(MockLowLevelHttpResponse response) {
        this.response = response;
        return this;
    }
}

