/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGoogleClient {
    static final Logger LOGGER = Logger.getLogger(AbstractGoogleClient.class.getName());
    private final HttpRequestFactory requestFactory;
    private final GoogleClientRequestInitializer googleClientRequestInitializer;
    private final String rootUrl;
    private final String servicePath;
    private final String applicationName;
    private final ObjectParser objectParser;
    private boolean suppressPatternChecks;

    protected AbstractGoogleClient(HttpTransport transport, HttpRequestInitializer httpRequestInitializer, String rootUrl, String servicePath, ObjectParser objectParser) {
        this(transport, httpRequestInitializer, rootUrl, servicePath, objectParser, null, null, false);
    }

    protected AbstractGoogleClient(HttpTransport transport, HttpRequestInitializer httpRequestInitializer, String rootUrl, String servicePath, ObjectParser objectParser, GoogleClientRequestInitializer googleClientRequestInitializer, String applicationName, boolean suppressPatternChecks) {
        this.googleClientRequestInitializer = googleClientRequestInitializer;
        this.rootUrl = AbstractGoogleClient.normalizeRootUrl(rootUrl);
        this.servicePath = AbstractGoogleClient.normalizeServicePath(servicePath);
        this.applicationName = applicationName;
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
        this.objectParser = objectParser;
        this.suppressPatternChecks = suppressPatternChecks;
    }

    public final String getRootUrl() {
        return this.rootUrl;
    }

    public final String getServicePath() {
        return this.servicePath;
    }

    public final String getBaseUrl() {
        return this.rootUrl + this.servicePath;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
        return this.googleClientRequestInitializer;
    }

    public ObjectParser getObjectParser() {
        return this.objectParser;
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        if (this.getGoogleClientRequestInitializer() != null) {
            this.getGoogleClientRequestInitializer().initialize(httpClientRequest);
        }
    }

    public final BatchRequest batch() {
        return this.batch(null);
    }

    public final BatchRequest batch(HttpRequestInitializer httpRequestInitializer) {
        BatchRequest batch = new BatchRequest(this.getRequestFactory().getTransport(), httpRequestInitializer);
        batch.setBatchUrl(new GenericUrl(this.getRootUrl() + "batch"));
        return batch;
    }

    public final boolean getSuppressPatternChecks() {
        return this.suppressPatternChecks;
    }

    static String normalizeRootUrl(String rootUrl) {
        Preconditions.checkNotNull((Object)rootUrl, (Object)"root URL cannot be null.");
        if (!rootUrl.endsWith("/")) {
            rootUrl = rootUrl + "/";
        }
        return rootUrl;
    }

    static String normalizeServicePath(String servicePath) {
        Preconditions.checkNotNull((Object)servicePath, (Object)"service path cannot be null");
        if (servicePath.length() == 1) {
            Preconditions.checkArgument((boolean)"/".equals(servicePath), (Object)"service path must equal \"/\" if it is of length 1.");
            servicePath = "";
        } else if (servicePath.length() > 0) {
            if (!servicePath.endsWith("/")) {
                servicePath = servicePath + "/";
            }
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
        }
        return servicePath;
    }

    public static abstract class Builder {
        private final HttpTransport transport;
        private GoogleClientRequestInitializer googleClientRequestInitializer;
        private HttpRequestInitializer httpRequestInitializer;
        private final ObjectParser objectParser;
        private String rootUrl;
        private String servicePath;
        private String applicationName;
        private boolean suppressPatternChecks;

        protected Builder(HttpTransport transport, String rootUrl, String servicePath, ObjectParser objectParser, HttpRequestInitializer httpRequestInitializer) {
            this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
            this.objectParser = (ObjectParser)Preconditions.checkNotNull((Object)objectParser);
            this.setRootUrl(rootUrl);
            this.setServicePath(servicePath);
            this.httpRequestInitializer = httpRequestInitializer;
        }

        public abstract AbstractGoogleClient build();

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public ObjectParser getObjectParser() {
            return this.objectParser;
        }

        public final String getRootUrl() {
            return this.rootUrl;
        }

        public Builder setRootUrl(String rootUrl) {
            this.rootUrl = AbstractGoogleClient.normalizeRootUrl(rootUrl);
            return this;
        }

        public final String getServicePath() {
            return this.servicePath;
        }

        public Builder setServicePath(String servicePath) {
            this.servicePath = AbstractGoogleClient.normalizeServicePath(servicePath);
            return this;
        }

        public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
            return this.googleClientRequestInitializer;
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            this.googleClientRequestInitializer = googleClientRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final boolean getSuppressPatternChecks() {
            return this.suppressPatternChecks;
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            this.suppressPatternChecks = suppressPatternChecks;
            return this;
        }
    }
}

