/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.config;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.config.ConfigurationException;
import org.jsecurity.config.UnresolveableReferenceException;
import org.jsecurity.util.ClassUtils;
import org.jsecurity.util.Nameable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionBuilder {
    private static final Log log = LogFactory.getLog(ReflectionBuilder.class);
    private static final String OBJECT_REFERENCE_BEGIN_TOKEN = "$";
    private static final String ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN = "\\$";
    private static final String GLOBAL_PROPERTY_PREFIX = "jsecurity";
    protected Map objects;

    public ReflectionBuilder() {
        this.setObjects(new LinkedHashMap());
    }

    public ReflectionBuilder(Map defaults) {
        this.setObjects(defaults);
    }

    public Map getObjects() {
        return this.objects;
    }

    public void setObjects(Map objects) {
        this.objects = objects;
    }

    public Map buildObjects(Map<String, String> kvPairs) {
        if (kvPairs != null && !kvPairs.isEmpty()) {
            HashMap<String, String> instanceMap = new HashMap<String, String>();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : kvPairs.entrySet()) {
                if (entry.getKey().indexOf(46) < 0 || entry.getKey().endsWith(".class")) {
                    instanceMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                propertyMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : instanceMap.entrySet()) {
                this.createNewInstance(this.objects, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                this.applyProperty(entry.getKey(), entry.getValue(), this.objects);
            }
        }
        return this.objects;
    }

    protected void createNewInstance(Map objects, String name, String value) {
        Object instance;
        Object currentInstance = objects.get(name);
        if (currentInstance != null) {
            log.info((Object)("An instance with name [" + name + "] already exists.  " + "Redefining this object as a new instance of type [" + value + "]."));
        }
        try {
            instance = ClassUtils.newInstance(value);
            if (instance instanceof Nameable) {
                ((Nameable)instance).setName(name);
            }
        }
        catch (Exception e) {
            String msg = "Unable to instantiate class [" + value + "] for object named '" + name + "'.  " + "Please ensure you've specified the fully qualified class name correctly.";
            throw new ConfigurationException(msg, e);
        }
        objects.put(name, instance);
    }

    protected void applyProperty(String key, String value, Map objects) {
        int index = key.indexOf(46);
        if (index >= 0) {
            String name = key.substring(0, index);
            String property = key.substring(index + 1, key.length());
            if (GLOBAL_PROPERTY_PREFIX.equalsIgnoreCase(name)) {
                this.applyGlobalProperty(objects, property, value);
            } else {
                this.applySingleProperty(objects, name, property, value);
            }
        } else {
            throw new IllegalArgumentException("All property keys must contain a '.' character. (e.g. myBean.property = value)  These should already be separated out by buildObjects().");
        }
    }

    protected void applyGlobalProperty(Map objects, String property, String value) {
        for (Object instance : objects.values()) {
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(instance, (String)property);
                if (pd == null) continue;
                this.applyProperty(instance, property, value);
            }
            catch (Exception e) {
                String msg = "Error retrieving property descriptor for instance of type [" + instance.getClass().getName() + "] " + "while setting property [" + property + "]";
                throw new ConfigurationException(msg, e);
            }
        }
    }

    protected void applySingleProperty(Map objects, String name, String property, String value) {
        Object instance = objects.get(name);
        if (property.equals("class")) {
            throw new IllegalArgumentException("Property keys should not contain 'class' properties since these should already be separated out by buildObjects().");
        }
        if (instance == null) {
            String msg = "Configuration error.  Specified object [" + name + "] with property [" + property + "] without first defining that object's class.  Please first " + "specify the class property first, e.g. myObject.class = fully_qualified_class_name " + "and then define additional properties.";
            throw new IllegalArgumentException(msg);
        }
        this.applyProperty(instance, property, value);
    }

    protected boolean isReference(String value) {
        return value != null && value.startsWith(OBJECT_REFERENCE_BEGIN_TOKEN);
    }

    protected String getId(String referenceToken) {
        return referenceToken.substring(OBJECT_REFERENCE_BEGIN_TOKEN.length());
    }

    protected Object getReferencedObject(String id) {
        Object o;
        Object v0 = o = this.objects != null && !this.objects.isEmpty() ? this.objects.get(id) : null;
        if (o == null) {
            String msg = "The object with id [" + id + "] has not yet been defined and therefore cannot be " + "referenced.  Please ensure objects are defined in the order in which they should be " + "created and made avaialable for future reference.";
            throw new UnresolveableReferenceException(msg);
        }
        return o;
    }

    protected String unescapeIfNecessary(String value) {
        if (value != null && value.startsWith(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN)) {
            return value.substring(ESCAPED_OBJECT_REFERENCE_BEGIN_TOKEN.length() - 1);
        }
        return value;
    }

    protected void applyProperty(Object object, String propertyName, String stringValue) {
        Object value;
        if (this.isReference(stringValue)) {
            String id = this.getId(stringValue);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Encountered object reference [" + stringValue + "].  Looking up object " + "with id [" + id + "]"));
            }
            value = this.getReferencedObject(id);
        } else {
            value = this.unescapeIfNecessary(stringValue);
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Applying property [" + propertyName + "] value [" + value + "] on object of type [" + object.getClass().getName() + "]"));
            }
            BeanUtils.setProperty((Object)object, (String)propertyName, (Object)value);
        }
        catch (Exception e) {
            String msg = "Unable to set property [" + propertyName + "] with value [" + stringValue + "].  If " + "'" + stringValue + "' is a reference to another (previously defined) object, please prefix it with " + "'" + OBJECT_REFERENCE_BEGIN_TOKEN + "' to indicate that the referenced " + "object should be used as the actual value.  " + "For example, " + OBJECT_REFERENCE_BEGIN_TOKEN + stringValue;
            throw new ConfigurationException(msg, e);
        }
    }
}

