/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.parser.ParseTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AncestorChain<T extends ParseTreeNode> {
    public final AncestorChain<? extends ParseTreeNode> parent;
    public final T node;
    public final int depth;
    private int hc;

    private AncestorChain(AncestorChain<? extends ParseTreeNode> parent, T node) {
        if (node == null) {
            throw new NullPointerException();
        }
        assert (parent == null || parent.node.children().contains(node));
        this.parent = parent;
        this.node = node;
        this.depth = parent == null ? 0 : parent.depth + 1;
    }

    public static <T extends ParseTreeNode> AncestorChain<T> instance(T node) {
        return new AncestorChain<T>(null, node);
    }

    public static <T extends ParseTreeNode> AncestorChain<T> instance(AncestorChain<? extends ParseTreeNode> parent, T node) {
        return new AncestorChain<T>(parent, node);
    }

    public <C extends ParseTreeNode> AncestorChain<C> child(C child) {
        return AncestorChain.instance(this, child);
    }

    public boolean isFirstSibling() {
        return this.parent == null || this.parent.node.children().get(0) == this.node;
    }

    public boolean isLastSibling() {
        return this.parent == null || this.parent.node.children().get(this.parent.node.children().size() - 1) == this.node;
    }

    public ParseTreeNode getPrevSibling() {
        int idx = this.indexInParent() - 1;
        if (idx < 0) {
            return null;
        }
        return this.parent.node.children().get(idx);
    }

    public ParseTreeNode getNextSibling() {
        int idx = this.indexInParent() + 1;
        if (idx <= 0 || idx >= this.parent.node.children().size()) {
            return null;
        }
        return this.parent.node.children().get(idx);
    }

    public int indexInParent() {
        return this.parent == null ? -1 : this.parent.node.children().indexOf(this.node);
    }

    public ParseTreeNode getParentNode() {
        return this.parent != null ? (ParseTreeNode)this.parent.node : null;
    }

    public <C extends ParseTreeNode> AncestorChain<C> cast(Class<C> clazz) {
        if (!clazz.isInstance(this.node)) {
            throw new ClassCastException(this.node.getClass().getSimpleName());
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private int toString(StringBuilder sb) {
        int depth = 0;
        if (this.parent != null) {
            depth = super.toString(sb) + 1;
            sb.append('\n');
        }
        int d = depth;
        while (--d >= 0) {
            sb.append("  ");
        }
        sb.append(this.node);
        return depth;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AncestorChain)) {
            return false;
        }
        AncestorChain<? extends ParseTreeNode> a = this;
        AncestorChain<? extends ParseTreeNode> b = (AncestorChain<? extends ParseTreeNode>)o;
        if (a.depth != b.depth) {
            return false;
        }
        do {
            if (a.node != b.node) {
                return false;
            }
            if (a.hc != 0 && b.hc != 0 && a.hc != b.hc) {
                return false;
            }
            a = a.parent;
            b = b.parent;
            if (a != b) continue;
            return true;
        } while (a != null && b != null);
        return false;
    }

    public int hashCode() {
        if (this.hc == 0) {
            int hc = (this.parent != null ? 31 * this.parent.hashCode() : 0) + System.identityHashCode(this.node);
            if (hc == 0) {
                hc = -1;
            }
            this.hc = hc;
        }
        return this.hc;
    }
}

