/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UncajoledModule
extends AbstractParseTreeNode {
    @ParseTreeNode.ReflectiveCtor
    public UncajoledModule(FilePosition pos, Void value, List<? extends Block> children) {
        this(pos, children.get(0));
        assert (children.size() == 1);
    }

    public UncajoledModule(FilePosition pos, Block body) {
        super(pos, Block.class);
        this.createMutation().appendChild(body).execute();
    }

    public UncajoledModule(Block body) {
        this(FilePosition.UNKNOWN, body);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.children().size() != 1) {
            throw new IllegalStateException("An UncajoledModule may only have one child");
        }
        ParseTreeNode module = this.children().get(0);
        if (!(module instanceof Block)) {
            throw new ClassCastException("Expected block, not " + module);
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends Block> children() {
        return this.childrenAs(Block.class);
    }

    public Block getModuleBody() {
        return this.children().get(0);
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.consume("/* Start Uncajoled Module */");
        out.consume("throw");
        out.consume("'Uncajoled Module must never be executed'");
        out.consume(";");
        this.getModuleBody().render(rc);
        out.consume("/* End Uncajoled Module */");
    }
}

