/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.blogs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.webengine.sites.Page;
import org.nuxeo.webengine.sites.utils.SiteUtils;

@WebObject(type="BlogPost", facets={"BlogPost"})
@Produces(value={"text/html;charset=UTF-8"})
public class BlogPost
extends Page {
    @Path(value="{path}")
    public Resource traverse(@PathParam(value="path") String path) {
        return super.traverse(path);
    }

    protected void setSearchParameters() {
        super.setSearchParameters();
        String year = this.ctx.getRequest().getParameter("year");
        String month = this.ctx.getRequest().getParameter("month");
        if (year != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", WebEngine.getActiveContext().getLocale());
            if (month != null) {
                GregorianCalendar calendar = new GregorianCalendar(new Integer(year), new Integer(month) - 1, 1);
                this.ctx.setProperty("dateAfter", (Object)simpleDateFormat.format(calendar.getTime()));
                ((Calendar)calendar).add(2, 1);
                this.ctx.setProperty("dateBefore", (Object)simpleDateFormat.format(calendar.getTime()));
            } else {
                GregorianCalendar calendar = new GregorianCalendar(new Integer(year), 0, 1);
                this.ctx.setProperty("dateAfter", (Object)simpleDateFormat.format(calendar.getTime()));
                ((Calendar)calendar).add(1, 1);
                this.ctx.setProperty("dateBefore", (Object)simpleDateFormat.format(calendar.getTime()));
            }
        }
    }

    protected String getWebPageDocumentType() {
        return "BlogPost";
    }

    protected String getDefaultSchemaFieldThemeValue() {
        return "blogs";
    }

    protected String getDefaultSchemaFieldThemePageValue() {
        return "page";
    }

    protected String getSearchThemePage() {
        return "blogs/search";
    }

    public String getIdForRss() {
        try {
            return SiteUtils.getFirstWebSiteParent((CoreSession)this.ctx.getCoreSession(), (DocumentModel)this.doc).getId();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected String getDocumentDeletedErrorTemplateName() {
        return "error_deleted_blog_entry.ftl";
    }
}

