/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.dm.codec;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class FacetedSearchViewCodec
extends AbstractDocumentViewCodec {
    public static final String PREFIX = "nxsrch";
    public static final String QUERY_ALL = "SELECT * FROM Document ORDER BY ecm:path";
    public static final String URL_PATTERN = "/([\\w\\.]+)(/)?(\\?(.*)?)?";
    protected String prefix;

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URL_PATTERN);
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            String server = m.group(1);
            Map params = null;
            if (m.groupCount() > 2) {
                String query = m.group(3);
                params = URIUtils.getRequestParameters((String)query);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, null);
            return new DocumentViewImpl((DocumentLocation)docLoc, "faceted_search_results", params);
        }
        return null;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        String serverName;
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null && (serverName = docLoc.getServerName()) != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(serverName);
            String uri = StringUtils.join(items, (String)"/") + "/";
            uri = URIUtils.addParametersToURIQuery((String)uri, (Map)docView.getParameters());
            return uri;
        }
        return null;
    }

    public boolean handleDocumentView(DocumentView docView) {
        return false;
    }
}

